/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.DescribePublicIpv4PoolsRequest;
import com.amazonaws.services.ec2.model.Filter;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class DescribePublicIpv4PoolsRequestMarshaller
implements Marshaller<Request<DescribePublicIpv4PoolsRequest>, DescribePublicIpv4PoolsRequest> {
    public Request<DescribePublicIpv4PoolsRequest> marshall(DescribePublicIpv4PoolsRequest describePublicIpv4PoolsRequest) {
        SdkInternalList describePublicIpv4PoolsRequestFiltersList;
        if (describePublicIpv4PoolsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describePublicIpv4PoolsRequest, "AmazonEC2");
        request.addParameter("Action", "DescribePublicIpv4Pools");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        SdkInternalList describePublicIpv4PoolsRequestPoolIdsList = (SdkInternalList)describePublicIpv4PoolsRequest.getPoolIds();
        if (!describePublicIpv4PoolsRequestPoolIdsList.isEmpty() || !describePublicIpv4PoolsRequestPoolIdsList.isAutoConstruct()) {
            int poolIdsListIndex = 1;
            for (String describePublicIpv4PoolsRequestPoolIdsListValue : describePublicIpv4PoolsRequestPoolIdsList) {
                if (describePublicIpv4PoolsRequestPoolIdsListValue != null) {
                    request.addParameter("PoolId." + poolIdsListIndex, StringUtils.fromString((String)describePublicIpv4PoolsRequestPoolIdsListValue));
                }
                ++poolIdsListIndex;
            }
        }
        if (describePublicIpv4PoolsRequest.getNextToken() != null) {
            request.addParameter("NextToken", StringUtils.fromString((String)describePublicIpv4PoolsRequest.getNextToken()));
        }
        if (describePublicIpv4PoolsRequest.getMaxResults() != null) {
            request.addParameter("MaxResults", StringUtils.fromInteger((Integer)describePublicIpv4PoolsRequest.getMaxResults()));
        }
        if (!(describePublicIpv4PoolsRequestFiltersList = (SdkInternalList)describePublicIpv4PoolsRequest.getFilters()).isEmpty() || !describePublicIpv4PoolsRequestFiltersList.isAutoConstruct()) {
            int filtersListIndex = 1;
            for (Filter describePublicIpv4PoolsRequestFiltersListValue : describePublicIpv4PoolsRequestFiltersList) {
                SdkInternalList filterValuesList;
                if (describePublicIpv4PoolsRequestFiltersListValue.getName() != null) {
                    request.addParameter("Filter." + filtersListIndex + ".Name", StringUtils.fromString((String)describePublicIpv4PoolsRequestFiltersListValue.getName()));
                }
                if (!(filterValuesList = (SdkInternalList)describePublicIpv4PoolsRequestFiltersListValue.getValues()).isEmpty() || !filterValuesList.isAutoConstruct()) {
                    int valuesListIndex = 1;
                    for (String filterValuesListValue : filterValuesList) {
                        if (filterValuesListValue != null) {
                            request.addParameter("Filter." + filtersListIndex + ".Value." + valuesListIndex, StringUtils.fromString((String)filterValuesListValue));
                        }
                        ++valuesListIndex;
                    }
                }
                ++filtersListIndex;
            }
        }
        return request;
    }
}

