/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.Request;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.AutoPlacement;
import com.amazonaws.services.ec2.model.DryRunSupportedRequest;
import com.amazonaws.services.ec2.model.HostRecovery;
import com.amazonaws.services.ec2.model.transform.ModifyHostsRequestMarshaller;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class ModifyHostsRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable,
DryRunSupportedRequest<ModifyHostsRequest> {
    private String autoPlacement;
    private SdkInternalList<String> hostIds;
    private String hostRecovery;
    private String instanceType;
    private String instanceFamily;

    public void setAutoPlacement(String autoPlacement) {
        this.autoPlacement = autoPlacement;
    }

    public String getAutoPlacement() {
        return this.autoPlacement;
    }

    public ModifyHostsRequest withAutoPlacement(String autoPlacement) {
        this.setAutoPlacement(autoPlacement);
        return this;
    }

    public void setAutoPlacement(AutoPlacement autoPlacement) {
        this.withAutoPlacement(autoPlacement);
    }

    public ModifyHostsRequest withAutoPlacement(AutoPlacement autoPlacement) {
        this.autoPlacement = autoPlacement.toString();
        return this;
    }

    public List<String> getHostIds() {
        if (this.hostIds == null) {
            this.hostIds = new SdkInternalList();
        }
        return this.hostIds;
    }

    public void setHostIds(Collection<String> hostIds) {
        if (hostIds == null) {
            this.hostIds = null;
            return;
        }
        this.hostIds = new SdkInternalList(hostIds);
    }

    public ModifyHostsRequest withHostIds(String ... hostIds) {
        if (this.hostIds == null) {
            this.setHostIds((Collection<String>)new SdkInternalList(hostIds.length));
        }
        for (String ele : hostIds) {
            this.hostIds.add((Object)ele);
        }
        return this;
    }

    public ModifyHostsRequest withHostIds(Collection<String> hostIds) {
        this.setHostIds(hostIds);
        return this;
    }

    public void setHostRecovery(String hostRecovery) {
        this.hostRecovery = hostRecovery;
    }

    public String getHostRecovery() {
        return this.hostRecovery;
    }

    public ModifyHostsRequest withHostRecovery(String hostRecovery) {
        this.setHostRecovery(hostRecovery);
        return this;
    }

    public void setHostRecovery(HostRecovery hostRecovery) {
        this.withHostRecovery(hostRecovery);
    }

    public ModifyHostsRequest withHostRecovery(HostRecovery hostRecovery) {
        this.hostRecovery = hostRecovery.toString();
        return this;
    }

    public void setInstanceType(String instanceType) {
        this.instanceType = instanceType;
    }

    public String getInstanceType() {
        return this.instanceType;
    }

    public ModifyHostsRequest withInstanceType(String instanceType) {
        this.setInstanceType(instanceType);
        return this;
    }

    public void setInstanceFamily(String instanceFamily) {
        this.instanceFamily = instanceFamily;
    }

    public String getInstanceFamily() {
        return this.instanceFamily;
    }

    public ModifyHostsRequest withInstanceFamily(String instanceFamily) {
        this.setInstanceFamily(instanceFamily);
        return this;
    }

    @Override
    public Request<ModifyHostsRequest> getDryRunRequest() {
        Request<ModifyHostsRequest> request = new ModifyHostsRequestMarshaller().marshall(this);
        request.addParameter("DryRun", Boolean.toString(true));
        return request;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAutoPlacement() != null) {
            sb.append("AutoPlacement: ").append(this.getAutoPlacement()).append(",");
        }
        if (this.getHostIds() != null) {
            sb.append("HostIds: ").append(this.getHostIds()).append(",");
        }
        if (this.getHostRecovery() != null) {
            sb.append("HostRecovery: ").append(this.getHostRecovery()).append(",");
        }
        if (this.getInstanceType() != null) {
            sb.append("InstanceType: ").append(this.getInstanceType()).append(",");
        }
        if (this.getInstanceFamily() != null) {
            sb.append("InstanceFamily: ").append(this.getInstanceFamily());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyHostsRequest)) {
            return false;
        }
        ModifyHostsRequest other = (ModifyHostsRequest)obj;
        if (other.getAutoPlacement() == null ^ this.getAutoPlacement() == null) {
            return false;
        }
        if (other.getAutoPlacement() != null && !other.getAutoPlacement().equals(this.getAutoPlacement())) {
            return false;
        }
        if (other.getHostIds() == null ^ this.getHostIds() == null) {
            return false;
        }
        if (other.getHostIds() != null && !other.getHostIds().equals(this.getHostIds())) {
            return false;
        }
        if (other.getHostRecovery() == null ^ this.getHostRecovery() == null) {
            return false;
        }
        if (other.getHostRecovery() != null && !other.getHostRecovery().equals(this.getHostRecovery())) {
            return false;
        }
        if (other.getInstanceType() == null ^ this.getInstanceType() == null) {
            return false;
        }
        if (other.getInstanceType() != null && !other.getInstanceType().equals(this.getInstanceType())) {
            return false;
        }
        if (other.getInstanceFamily() == null ^ this.getInstanceFamily() == null) {
            return false;
        }
        return other.getInstanceFamily() == null || other.getInstanceFamily().equals(this.getInstanceFamily());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAutoPlacement() == null ? 0 : this.getAutoPlacement().hashCode());
        hashCode = 31 * hashCode + (this.getHostIds() == null ? 0 : this.getHostIds().hashCode());
        hashCode = 31 * hashCode + (this.getHostRecovery() == null ? 0 : this.getHostRecovery().hashCode());
        hashCode = 31 * hashCode + (this.getInstanceType() == null ? 0 : this.getInstanceType().hashCode());
        hashCode = 31 * hashCode + (this.getInstanceFamily() == null ? 0 : this.getInstanceFamily().hashCode());
        return hashCode;
    }

    public ModifyHostsRequest clone() {
        return (ModifyHostsRequest)super.clone();
    }
}

