/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.services.ec2.model.KeyPair;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import javax.xml.stream.events.XMLEvent;

public class KeyPairStaxUnmarshaller
implements Unmarshaller<KeyPair, StaxUnmarshallerContext> {
    private static KeyPairStaxUnmarshaller instance;

    public KeyPair unmarshall(StaxUnmarshallerContext context) throws Exception {
        KeyPair keyPair = new KeyPair();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return keyPair;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("keyFingerprint", targetDepth)) {
                    keyPair.setKeyFingerprint(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("keyMaterial", targetDepth)) {
                    keyPair.setKeyMaterial(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("keyName", targetDepth)) {
                    keyPair.setKeyName(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("keyPairId", targetDepth)) continue;
                keyPair.setKeyPairId(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return keyPair;
    }

    public static KeyPairStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new KeyPairStaxUnmarshaller();
        }
        return instance;
    }
}

