/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.Request;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.DryRunSupportedRequest;
import com.amazonaws.services.ec2.model.transform.AssignIpv6AddressesRequestMarshaller;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class AssignIpv6AddressesRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable,
DryRunSupportedRequest<AssignIpv6AddressesRequest> {
    private String networkInterfaceId;
    private SdkInternalList<String> ipv6Addresses;
    private Integer ipv6AddressCount;

    public void setNetworkInterfaceId(String networkInterfaceId) {
        this.networkInterfaceId = networkInterfaceId;
    }

    public String getNetworkInterfaceId() {
        return this.networkInterfaceId;
    }

    public AssignIpv6AddressesRequest withNetworkInterfaceId(String networkInterfaceId) {
        this.setNetworkInterfaceId(networkInterfaceId);
        return this;
    }

    public List<String> getIpv6Addresses() {
        if (this.ipv6Addresses == null) {
            this.ipv6Addresses = new SdkInternalList();
        }
        return this.ipv6Addresses;
    }

    public void setIpv6Addresses(Collection<String> ipv6Addresses) {
        if (ipv6Addresses == null) {
            this.ipv6Addresses = null;
            return;
        }
        this.ipv6Addresses = new SdkInternalList(ipv6Addresses);
    }

    public AssignIpv6AddressesRequest withIpv6Addresses(String ... ipv6Addresses) {
        if (this.ipv6Addresses == null) {
            this.setIpv6Addresses((Collection<String>)new SdkInternalList(ipv6Addresses.length));
        }
        for (String ele : ipv6Addresses) {
            this.ipv6Addresses.add((Object)ele);
        }
        return this;
    }

    public AssignIpv6AddressesRequest withIpv6Addresses(Collection<String> ipv6Addresses) {
        this.setIpv6Addresses(ipv6Addresses);
        return this;
    }

    public void setIpv6AddressCount(Integer ipv6AddressCount) {
        this.ipv6AddressCount = ipv6AddressCount;
    }

    public Integer getIpv6AddressCount() {
        return this.ipv6AddressCount;
    }

    public AssignIpv6AddressesRequest withIpv6AddressCount(Integer ipv6AddressCount) {
        this.setIpv6AddressCount(ipv6AddressCount);
        return this;
    }

    @Override
    public Request<AssignIpv6AddressesRequest> getDryRunRequest() {
        Request<AssignIpv6AddressesRequest> request = new AssignIpv6AddressesRequestMarshaller().marshall(this);
        request.addParameter("DryRun", Boolean.toString(true));
        return request;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getNetworkInterfaceId() != null) {
            sb.append("NetworkInterfaceId: " + this.getNetworkInterfaceId() + ",");
        }
        if (this.getIpv6Addresses() != null) {
            sb.append("Ipv6Addresses: " + this.getIpv6Addresses() + ",");
        }
        if (this.getIpv6AddressCount() != null) {
            sb.append("Ipv6AddressCount: " + this.getIpv6AddressCount());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssignIpv6AddressesRequest)) {
            return false;
        }
        AssignIpv6AddressesRequest other = (AssignIpv6AddressesRequest)obj;
        if (other.getNetworkInterfaceId() == null ^ this.getNetworkInterfaceId() == null) {
            return false;
        }
        if (other.getNetworkInterfaceId() != null && !other.getNetworkInterfaceId().equals(this.getNetworkInterfaceId())) {
            return false;
        }
        if (other.getIpv6Addresses() == null ^ this.getIpv6Addresses() == null) {
            return false;
        }
        if (other.getIpv6Addresses() != null && !other.getIpv6Addresses().equals(this.getIpv6Addresses())) {
            return false;
        }
        if (other.getIpv6AddressCount() == null ^ this.getIpv6AddressCount() == null) {
            return false;
        }
        return other.getIpv6AddressCount() == null || other.getIpv6AddressCount().equals(this.getIpv6AddressCount());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getNetworkInterfaceId() == null ? 0 : this.getNetworkInterfaceId().hashCode());
        hashCode = 31 * hashCode + (this.getIpv6Addresses() == null ? 0 : this.getIpv6Addresses().hashCode());
        hashCode = 31 * hashCode + (this.getIpv6AddressCount() == null ? 0 : this.getIpv6AddressCount().hashCode());
        return hashCode;
    }

    public AssignIpv6AddressesRequest clone() {
        return (AssignIpv6AddressesRequest)super.clone();
    }
}

