/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.ConnectionLogOptions;
import com.amazonaws.services.ec2.model.DnsServersOptionsModifyStructure;
import com.amazonaws.services.ec2.model.ModifyClientVpnEndpointRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class ModifyClientVpnEndpointRequestMarshaller
implements Marshaller<Request<ModifyClientVpnEndpointRequest>, ModifyClientVpnEndpointRequest> {
    public Request<ModifyClientVpnEndpointRequest> marshall(ModifyClientVpnEndpointRequest modifyClientVpnEndpointRequest) {
        DnsServersOptionsModifyStructure dnsServers;
        ConnectionLogOptions connectionLogOptions;
        if (modifyClientVpnEndpointRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)modifyClientVpnEndpointRequest, "AmazonEC2");
        request.addParameter("Action", "ModifyClientVpnEndpoint");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (modifyClientVpnEndpointRequest.getClientVpnEndpointId() != null) {
            request.addParameter("ClientVpnEndpointId", StringUtils.fromString((String)modifyClientVpnEndpointRequest.getClientVpnEndpointId()));
        }
        if (modifyClientVpnEndpointRequest.getServerCertificateArn() != null) {
            request.addParameter("ServerCertificateArn", StringUtils.fromString((String)modifyClientVpnEndpointRequest.getServerCertificateArn()));
        }
        if ((connectionLogOptions = modifyClientVpnEndpointRequest.getConnectionLogOptions()) != null) {
            if (connectionLogOptions.getEnabled() != null) {
                request.addParameter("ConnectionLogOptions.Enabled", StringUtils.fromBoolean((Boolean)connectionLogOptions.getEnabled()));
            }
            if (connectionLogOptions.getCloudwatchLogGroup() != null) {
                request.addParameter("ConnectionLogOptions.CloudwatchLogGroup", StringUtils.fromString((String)connectionLogOptions.getCloudwatchLogGroup()));
            }
            if (connectionLogOptions.getCloudwatchLogStream() != null) {
                request.addParameter("ConnectionLogOptions.CloudwatchLogStream", StringUtils.fromString((String)connectionLogOptions.getCloudwatchLogStream()));
            }
        }
        if ((dnsServers = modifyClientVpnEndpointRequest.getDnsServers()) != null) {
            SdkInternalList dnsServersOptionsModifyStructureCustomDnsServersList = (SdkInternalList)dnsServers.getCustomDnsServers();
            if (!dnsServersOptionsModifyStructureCustomDnsServersList.isEmpty() || !dnsServersOptionsModifyStructureCustomDnsServersList.isAutoConstruct()) {
                int customDnsServersListIndex = 1;
                for (String dnsServersOptionsModifyStructureCustomDnsServersListValue : dnsServersOptionsModifyStructureCustomDnsServersList) {
                    if (dnsServersOptionsModifyStructureCustomDnsServersListValue != null) {
                        request.addParameter("DnsServers.CustomDnsServers." + customDnsServersListIndex, StringUtils.fromString((String)dnsServersOptionsModifyStructureCustomDnsServersListValue));
                    }
                    ++customDnsServersListIndex;
                }
            }
            if (dnsServers.getEnabled() != null) {
                request.addParameter("DnsServers.Enabled", StringUtils.fromBoolean((Boolean)dnsServers.getEnabled()));
            }
        }
        if (modifyClientVpnEndpointRequest.getDescription() != null) {
            request.addParameter("Description", StringUtils.fromString((String)modifyClientVpnEndpointRequest.getDescription()));
        }
        if (modifyClientVpnEndpointRequest.getSplitTunnel() != null) {
            request.addParameter("SplitTunnel", StringUtils.fromBoolean((Boolean)modifyClientVpnEndpointRequest.getSplitTunnel()));
        }
        return request;
    }
}

