/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.BlockDeviceMapping;
import com.amazonaws.services.ec2.model.EbsBlockDevice;
import com.amazonaws.services.ec2.model.IamInstanceProfileSpecification;
import com.amazonaws.services.ec2.model.InstanceNetworkInterfaceSpecification;
import com.amazonaws.services.ec2.model.Placement;
import com.amazonaws.services.ec2.model.PrivateIpAddressSpecification;
import com.amazonaws.services.ec2.model.RunInstancesRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class RunInstancesRequestMarshaller
implements Marshaller<Request<RunInstancesRequest>, RunInstancesRequest> {
    public Request<RunInstancesRequest> marshall(RunInstancesRequest runInstancesRequest) {
        IamInstanceProfileSpecification iamInstanceProfile;
        SdkInternalList runInstancesRequestNetworkInterfacesList;
        SdkInternalList runInstancesRequestBlockDeviceMappingsList;
        Placement placement;
        SdkInternalList runInstancesRequestSecurityGroupIdsList;
        SdkInternalList runInstancesRequestSecurityGroupsList;
        if (runInstancesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)runInstancesRequest, "AmazonEC2");
        request.addParameter("Action", "RunInstances");
        request.addParameter("Version", "2016-09-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (runInstancesRequest.getImageId() != null) {
            request.addParameter("ImageId", StringUtils.fromString((String)runInstancesRequest.getImageId()));
        }
        if (runInstancesRequest.getMinCount() != null) {
            request.addParameter("MinCount", StringUtils.fromInteger((Integer)runInstancesRequest.getMinCount()));
        }
        if (runInstancesRequest.getMaxCount() != null) {
            request.addParameter("MaxCount", StringUtils.fromInteger((Integer)runInstancesRequest.getMaxCount()));
        }
        if (runInstancesRequest.getKeyName() != null) {
            request.addParameter("KeyName", StringUtils.fromString((String)runInstancesRequest.getKeyName()));
        }
        if (!(runInstancesRequestSecurityGroupsList = (SdkInternalList)runInstancesRequest.getSecurityGroups()).isEmpty() || !runInstancesRequestSecurityGroupsList.isAutoConstruct()) {
            int securityGroupsListIndex = 1;
            for (Object runInstancesRequestSecurityGroupsListValue : runInstancesRequestSecurityGroupsList) {
                if (runInstancesRequestSecurityGroupsListValue != null) {
                    request.addParameter("SecurityGroup." + securityGroupsListIndex, StringUtils.fromString((String)runInstancesRequestSecurityGroupsListValue));
                }
                ++securityGroupsListIndex;
            }
        }
        if (!(runInstancesRequestSecurityGroupIdsList = (SdkInternalList)runInstancesRequest.getSecurityGroupIds()).isEmpty() || !runInstancesRequestSecurityGroupIdsList.isAutoConstruct()) {
            int securityGroupIdsListIndex = 1;
            for (String runInstancesRequestSecurityGroupIdsListValue : runInstancesRequestSecurityGroupIdsList) {
                if (runInstancesRequestSecurityGroupIdsListValue != null) {
                    request.addParameter("SecurityGroupId." + securityGroupIdsListIndex, StringUtils.fromString((String)runInstancesRequestSecurityGroupIdsListValue));
                }
                ++securityGroupIdsListIndex;
            }
        }
        if (runInstancesRequest.getUserData() != null) {
            request.addParameter("UserData", StringUtils.fromString((String)runInstancesRequest.getUserData()));
        }
        if (runInstancesRequest.getInstanceType() != null) {
            request.addParameter("InstanceType", StringUtils.fromString((String)runInstancesRequest.getInstanceType()));
        }
        if ((placement = runInstancesRequest.getPlacement()) != null) {
            if (placement.getAvailabilityZone() != null) {
                request.addParameter("Placement.AvailabilityZone", StringUtils.fromString((String)placement.getAvailabilityZone()));
            }
            if (placement.getGroupName() != null) {
                request.addParameter("Placement.GroupName", StringUtils.fromString((String)placement.getGroupName()));
            }
            if (placement.getTenancy() != null) {
                request.addParameter("Placement.Tenancy", StringUtils.fromString((String)placement.getTenancy()));
            }
            if (placement.getHostId() != null) {
                request.addParameter("Placement.HostId", StringUtils.fromString((String)placement.getHostId()));
            }
            if (placement.getAffinity() != null) {
                request.addParameter("Placement.Affinity", StringUtils.fromString((String)placement.getAffinity()));
            }
        }
        if (runInstancesRequest.getKernelId() != null) {
            request.addParameter("KernelId", StringUtils.fromString((String)runInstancesRequest.getKernelId()));
        }
        if (runInstancesRequest.getRamdiskId() != null) {
            request.addParameter("RamdiskId", StringUtils.fromString((String)runInstancesRequest.getRamdiskId()));
        }
        if (!(runInstancesRequestBlockDeviceMappingsList = (SdkInternalList)runInstancesRequest.getBlockDeviceMappings()).isEmpty() || !runInstancesRequestBlockDeviceMappingsList.isAutoConstruct()) {
            int blockDeviceMappingsListIndex = 1;
            for (BlockDeviceMapping runInstancesRequestBlockDeviceMappingsListValue : runInstancesRequestBlockDeviceMappingsList) {
                EbsBlockDevice ebs;
                if (runInstancesRequestBlockDeviceMappingsListValue.getVirtualName() != null) {
                    request.addParameter("BlockDeviceMapping." + blockDeviceMappingsListIndex + ".VirtualName", StringUtils.fromString((String)runInstancesRequestBlockDeviceMappingsListValue.getVirtualName()));
                }
                if (runInstancesRequestBlockDeviceMappingsListValue.getDeviceName() != null) {
                    request.addParameter("BlockDeviceMapping." + blockDeviceMappingsListIndex + ".DeviceName", StringUtils.fromString((String)runInstancesRequestBlockDeviceMappingsListValue.getDeviceName()));
                }
                if ((ebs = runInstancesRequestBlockDeviceMappingsListValue.getEbs()) != null) {
                    if (ebs.getSnapshotId() != null) {
                        request.addParameter("BlockDeviceMapping." + blockDeviceMappingsListIndex + ".Ebs.SnapshotId", StringUtils.fromString((String)ebs.getSnapshotId()));
                    }
                    if (ebs.getVolumeSize() != null) {
                        request.addParameter("BlockDeviceMapping." + blockDeviceMappingsListIndex + ".Ebs.VolumeSize", StringUtils.fromInteger((Integer)ebs.getVolumeSize()));
                    }
                    if (ebs.getDeleteOnTermination() != null) {
                        request.addParameter("BlockDeviceMapping." + blockDeviceMappingsListIndex + ".Ebs.DeleteOnTermination", StringUtils.fromBoolean((Boolean)ebs.getDeleteOnTermination()));
                    }
                    if (ebs.getVolumeType() != null) {
                        request.addParameter("BlockDeviceMapping." + blockDeviceMappingsListIndex + ".Ebs.VolumeType", StringUtils.fromString((String)ebs.getVolumeType()));
                    }
                    if (ebs.getIops() != null) {
                        request.addParameter("BlockDeviceMapping." + blockDeviceMappingsListIndex + ".Ebs.Iops", StringUtils.fromInteger((Integer)ebs.getIops()));
                    }
                    if (ebs.getEncrypted() != null) {
                        request.addParameter("BlockDeviceMapping." + blockDeviceMappingsListIndex + ".Ebs.Encrypted", StringUtils.fromBoolean((Boolean)ebs.getEncrypted()));
                    }
                }
                if (runInstancesRequestBlockDeviceMappingsListValue.getNoDevice() != null) {
                    request.addParameter("BlockDeviceMapping." + blockDeviceMappingsListIndex + ".NoDevice", StringUtils.fromString((String)runInstancesRequestBlockDeviceMappingsListValue.getNoDevice()));
                }
                ++blockDeviceMappingsListIndex;
            }
        }
        if (runInstancesRequest.getMonitoring() != null) {
            request.addParameter("Monitoring.Enabled", StringUtils.fromBoolean((Boolean)runInstancesRequest.getMonitoring()));
        }
        if (runInstancesRequest.getSubnetId() != null) {
            request.addParameter("SubnetId", StringUtils.fromString((String)runInstancesRequest.getSubnetId()));
        }
        if (runInstancesRequest.getDisableApiTermination() != null) {
            request.addParameter("DisableApiTermination", StringUtils.fromBoolean((Boolean)runInstancesRequest.getDisableApiTermination()));
        }
        if (runInstancesRequest.getInstanceInitiatedShutdownBehavior() != null) {
            request.addParameter("InstanceInitiatedShutdownBehavior", StringUtils.fromString((String)runInstancesRequest.getInstanceInitiatedShutdownBehavior()));
        }
        if (runInstancesRequest.getPrivateIpAddress() != null) {
            request.addParameter("PrivateIpAddress", StringUtils.fromString((String)runInstancesRequest.getPrivateIpAddress()));
        }
        if (runInstancesRequest.getClientToken() != null) {
            request.addParameter("ClientToken", StringUtils.fromString((String)runInstancesRequest.getClientToken()));
        }
        if (runInstancesRequest.getAdditionalInfo() != null) {
            request.addParameter("AdditionalInfo", StringUtils.fromString((String)runInstancesRequest.getAdditionalInfo()));
        }
        if (!(runInstancesRequestNetworkInterfacesList = (SdkInternalList)runInstancesRequest.getNetworkInterfaces()).isEmpty() || !runInstancesRequestNetworkInterfacesList.isAutoConstruct()) {
            int networkInterfacesListIndex = 1;
            for (InstanceNetworkInterfaceSpecification runInstancesRequestNetworkInterfacesListValue : runInstancesRequestNetworkInterfacesList) {
                SdkInternalList instanceNetworkInterfaceSpecificationPrivateIpAddressesList;
                SdkInternalList instanceNetworkInterfaceSpecificationGroupsList;
                if (runInstancesRequestNetworkInterfacesListValue.getNetworkInterfaceId() != null) {
                    request.addParameter("NetworkInterface." + networkInterfacesListIndex + ".NetworkInterfaceId", StringUtils.fromString((String)runInstancesRequestNetworkInterfacesListValue.getNetworkInterfaceId()));
                }
                if (runInstancesRequestNetworkInterfacesListValue.getDeviceIndex() != null) {
                    request.addParameter("NetworkInterface." + networkInterfacesListIndex + ".DeviceIndex", StringUtils.fromInteger((Integer)runInstancesRequestNetworkInterfacesListValue.getDeviceIndex()));
                }
                if (runInstancesRequestNetworkInterfacesListValue.getSubnetId() != null) {
                    request.addParameter("NetworkInterface." + networkInterfacesListIndex + ".SubnetId", StringUtils.fromString((String)runInstancesRequestNetworkInterfacesListValue.getSubnetId()));
                }
                if (runInstancesRequestNetworkInterfacesListValue.getDescription() != null) {
                    request.addParameter("NetworkInterface." + networkInterfacesListIndex + ".Description", StringUtils.fromString((String)runInstancesRequestNetworkInterfacesListValue.getDescription()));
                }
                if (runInstancesRequestNetworkInterfacesListValue.getPrivateIpAddress() != null) {
                    request.addParameter("NetworkInterface." + networkInterfacesListIndex + ".PrivateIpAddress", StringUtils.fromString((String)runInstancesRequestNetworkInterfacesListValue.getPrivateIpAddress()));
                }
                if (!(instanceNetworkInterfaceSpecificationGroupsList = (SdkInternalList)runInstancesRequestNetworkInterfacesListValue.getGroups()).isEmpty() || !instanceNetworkInterfaceSpecificationGroupsList.isAutoConstruct()) {
                    int groupsListIndex = 1;
                    for (String instanceNetworkInterfaceSpecificationGroupsListValue : instanceNetworkInterfaceSpecificationGroupsList) {
                        if (instanceNetworkInterfaceSpecificationGroupsListValue != null) {
                            request.addParameter("NetworkInterface." + networkInterfacesListIndex + ".SecurityGroupId." + groupsListIndex, StringUtils.fromString((String)instanceNetworkInterfaceSpecificationGroupsListValue));
                        }
                        ++groupsListIndex;
                    }
                }
                if (runInstancesRequestNetworkInterfacesListValue.getDeleteOnTermination() != null) {
                    request.addParameter("NetworkInterface." + networkInterfacesListIndex + ".DeleteOnTermination", StringUtils.fromBoolean((Boolean)runInstancesRequestNetworkInterfacesListValue.getDeleteOnTermination()));
                }
                if (!(instanceNetworkInterfaceSpecificationPrivateIpAddressesList = (SdkInternalList)runInstancesRequestNetworkInterfacesListValue.getPrivateIpAddresses()).isEmpty() || !instanceNetworkInterfaceSpecificationPrivateIpAddressesList.isAutoConstruct()) {
                    int privateIpAddressesListIndex = 1;
                    for (PrivateIpAddressSpecification instanceNetworkInterfaceSpecificationPrivateIpAddressesListValue : instanceNetworkInterfaceSpecificationPrivateIpAddressesList) {
                        if (instanceNetworkInterfaceSpecificationPrivateIpAddressesListValue.getPrivateIpAddress() != null) {
                            request.addParameter("NetworkInterface." + networkInterfacesListIndex + ".PrivateIpAddresses." + privateIpAddressesListIndex + ".PrivateIpAddress", StringUtils.fromString((String)instanceNetworkInterfaceSpecificationPrivateIpAddressesListValue.getPrivateIpAddress()));
                        }
                        if (instanceNetworkInterfaceSpecificationPrivateIpAddressesListValue.getPrimary() != null) {
                            request.addParameter("NetworkInterface." + networkInterfacesListIndex + ".PrivateIpAddresses." + privateIpAddressesListIndex + ".Primary", StringUtils.fromBoolean((Boolean)instanceNetworkInterfaceSpecificationPrivateIpAddressesListValue.getPrimary()));
                        }
                        ++privateIpAddressesListIndex;
                    }
                }
                if (runInstancesRequestNetworkInterfacesListValue.getSecondaryPrivateIpAddressCount() != null) {
                    request.addParameter("NetworkInterface." + networkInterfacesListIndex + ".SecondaryPrivateIpAddressCount", StringUtils.fromInteger((Integer)runInstancesRequestNetworkInterfacesListValue.getSecondaryPrivateIpAddressCount()));
                }
                if (runInstancesRequestNetworkInterfacesListValue.getAssociatePublicIpAddress() != null) {
                    request.addParameter("NetworkInterface." + networkInterfacesListIndex + ".AssociatePublicIpAddress", StringUtils.fromBoolean((Boolean)runInstancesRequestNetworkInterfacesListValue.getAssociatePublicIpAddress()));
                }
                ++networkInterfacesListIndex;
            }
        }
        if ((iamInstanceProfile = runInstancesRequest.getIamInstanceProfile()) != null) {
            if (iamInstanceProfile.getArn() != null) {
                request.addParameter("IamInstanceProfile.Arn", StringUtils.fromString((String)iamInstanceProfile.getArn()));
            }
            if (iamInstanceProfile.getName() != null) {
                request.addParameter("IamInstanceProfile.Name", StringUtils.fromString((String)iamInstanceProfile.getName()));
            }
        }
        if (runInstancesRequest.getEbsOptimized() != null) {
            request.addParameter("EbsOptimized", StringUtils.fromBoolean((Boolean)runInstancesRequest.getEbsOptimized()));
        }
        return request;
    }
}

