/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.Request;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.DryRunSupportedRequest;
import com.amazonaws.services.ec2.model.transform.AssignPrivateIpAddressesRequestMarshaller;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class AssignPrivateIpAddressesRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable,
DryRunSupportedRequest<AssignPrivateIpAddressesRequest> {
    private Boolean allowReassignment;
    private String networkInterfaceId;
    private SdkInternalList<String> privateIpAddresses;
    private Integer secondaryPrivateIpAddressCount;

    public void setAllowReassignment(Boolean allowReassignment) {
        this.allowReassignment = allowReassignment;
    }

    public Boolean getAllowReassignment() {
        return this.allowReassignment;
    }

    public AssignPrivateIpAddressesRequest withAllowReassignment(Boolean allowReassignment) {
        this.setAllowReassignment(allowReassignment);
        return this;
    }

    public Boolean isAllowReassignment() {
        return this.allowReassignment;
    }

    public void setNetworkInterfaceId(String networkInterfaceId) {
        this.networkInterfaceId = networkInterfaceId;
    }

    public String getNetworkInterfaceId() {
        return this.networkInterfaceId;
    }

    public AssignPrivateIpAddressesRequest withNetworkInterfaceId(String networkInterfaceId) {
        this.setNetworkInterfaceId(networkInterfaceId);
        return this;
    }

    public List<String> getPrivateIpAddresses() {
        if (this.privateIpAddresses == null) {
            this.privateIpAddresses = new SdkInternalList();
        }
        return this.privateIpAddresses;
    }

    public void setPrivateIpAddresses(Collection<String> privateIpAddresses) {
        if (privateIpAddresses == null) {
            this.privateIpAddresses = null;
            return;
        }
        this.privateIpAddresses = new SdkInternalList(privateIpAddresses);
    }

    public AssignPrivateIpAddressesRequest withPrivateIpAddresses(String ... privateIpAddresses) {
        if (this.privateIpAddresses == null) {
            this.setPrivateIpAddresses((Collection<String>)new SdkInternalList(privateIpAddresses.length));
        }
        for (String ele : privateIpAddresses) {
            this.privateIpAddresses.add((Object)ele);
        }
        return this;
    }

    public AssignPrivateIpAddressesRequest withPrivateIpAddresses(Collection<String> privateIpAddresses) {
        this.setPrivateIpAddresses(privateIpAddresses);
        return this;
    }

    public void setSecondaryPrivateIpAddressCount(Integer secondaryPrivateIpAddressCount) {
        this.secondaryPrivateIpAddressCount = secondaryPrivateIpAddressCount;
    }

    public Integer getSecondaryPrivateIpAddressCount() {
        return this.secondaryPrivateIpAddressCount;
    }

    public AssignPrivateIpAddressesRequest withSecondaryPrivateIpAddressCount(Integer secondaryPrivateIpAddressCount) {
        this.setSecondaryPrivateIpAddressCount(secondaryPrivateIpAddressCount);
        return this;
    }

    @Override
    public Request<AssignPrivateIpAddressesRequest> getDryRunRequest() {
        Request<AssignPrivateIpAddressesRequest> request = new AssignPrivateIpAddressesRequestMarshaller().marshall(this);
        request.addParameter("DryRun", Boolean.toString(true));
        return request;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAllowReassignment() != null) {
            sb.append("AllowReassignment: ").append(this.getAllowReassignment()).append(",");
        }
        if (this.getNetworkInterfaceId() != null) {
            sb.append("NetworkInterfaceId: ").append(this.getNetworkInterfaceId()).append(",");
        }
        if (this.getPrivateIpAddresses() != null) {
            sb.append("PrivateIpAddresses: ").append(this.getPrivateIpAddresses()).append(",");
        }
        if (this.getSecondaryPrivateIpAddressCount() != null) {
            sb.append("SecondaryPrivateIpAddressCount: ").append(this.getSecondaryPrivateIpAddressCount());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssignPrivateIpAddressesRequest)) {
            return false;
        }
        AssignPrivateIpAddressesRequest other = (AssignPrivateIpAddressesRequest)obj;
        if (other.getAllowReassignment() == null ^ this.getAllowReassignment() == null) {
            return false;
        }
        if (other.getAllowReassignment() != null && !other.getAllowReassignment().equals(this.getAllowReassignment())) {
            return false;
        }
        if (other.getNetworkInterfaceId() == null ^ this.getNetworkInterfaceId() == null) {
            return false;
        }
        if (other.getNetworkInterfaceId() != null && !other.getNetworkInterfaceId().equals(this.getNetworkInterfaceId())) {
            return false;
        }
        if (other.getPrivateIpAddresses() == null ^ this.getPrivateIpAddresses() == null) {
            return false;
        }
        if (other.getPrivateIpAddresses() != null && !other.getPrivateIpAddresses().equals(this.getPrivateIpAddresses())) {
            return false;
        }
        if (other.getSecondaryPrivateIpAddressCount() == null ^ this.getSecondaryPrivateIpAddressCount() == null) {
            return false;
        }
        return other.getSecondaryPrivateIpAddressCount() == null || other.getSecondaryPrivateIpAddressCount().equals(this.getSecondaryPrivateIpAddressCount());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAllowReassignment() == null ? 0 : this.getAllowReassignment().hashCode());
        hashCode = 31 * hashCode + (this.getNetworkInterfaceId() == null ? 0 : this.getNetworkInterfaceId().hashCode());
        hashCode = 31 * hashCode + (this.getPrivateIpAddresses() == null ? 0 : this.getPrivateIpAddresses().hashCode());
        hashCode = 31 * hashCode + (this.getSecondaryPrivateIpAddressCount() == null ? 0 : this.getSecondaryPrivateIpAddressCount().hashCode());
        return hashCode;
    }

    public AssignPrivateIpAddressesRequest clone() {
        return (AssignPrivateIpAddressesRequest)super.clone();
    }
}

