/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.DescribeHostReservationsRequest;
import com.amazonaws.services.ec2.model.Filter;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class DescribeHostReservationsRequestMarshaller
implements Marshaller<Request<DescribeHostReservationsRequest>, DescribeHostReservationsRequest> {
    public Request<DescribeHostReservationsRequest> marshall(DescribeHostReservationsRequest describeHostReservationsRequest) {
        SdkInternalList describeHostReservationsRequestFilterList;
        if (describeHostReservationsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeHostReservationsRequest, "AmazonEC2");
        request.addParameter("Action", "DescribeHostReservations");
        request.addParameter("Version", "2016-09-15");
        request.setHttpMethod(HttpMethodName.POST);
        SdkInternalList describeHostReservationsRequestHostReservationIdSetList = (SdkInternalList)describeHostReservationsRequest.getHostReservationIdSet();
        if (!describeHostReservationsRequestHostReservationIdSetList.isEmpty() || !describeHostReservationsRequestHostReservationIdSetList.isAutoConstruct()) {
            int hostReservationIdSetListIndex = 1;
            for (String describeHostReservationsRequestHostReservationIdSetListValue : describeHostReservationsRequestHostReservationIdSetList) {
                if (describeHostReservationsRequestHostReservationIdSetListValue != null) {
                    request.addParameter("HostReservationIdSet." + hostReservationIdSetListIndex, StringUtils.fromString((String)describeHostReservationsRequestHostReservationIdSetListValue));
                }
                ++hostReservationIdSetListIndex;
            }
        }
        if (!(describeHostReservationsRequestFilterList = (SdkInternalList)describeHostReservationsRequest.getFilter()).isEmpty() || !describeHostReservationsRequestFilterList.isAutoConstruct()) {
            int filterListIndex = 1;
            for (Filter describeHostReservationsRequestFilterListValue : describeHostReservationsRequestFilterList) {
                SdkInternalList filterValuesList;
                if (describeHostReservationsRequestFilterListValue.getName() != null) {
                    request.addParameter("Filter." + filterListIndex + ".Name", StringUtils.fromString((String)describeHostReservationsRequestFilterListValue.getName()));
                }
                if (!(filterValuesList = (SdkInternalList)describeHostReservationsRequestFilterListValue.getValues()).isEmpty() || !filterValuesList.isAutoConstruct()) {
                    int valuesListIndex = 1;
                    for (String filterValuesListValue : filterValuesList) {
                        if (filterValuesListValue != null) {
                            request.addParameter("Filter." + filterListIndex + ".Value." + valuesListIndex, StringUtils.fromString((String)filterValuesListValue));
                        }
                        ++valuesListIndex;
                    }
                }
                ++filterListIndex;
            }
        }
        if (describeHostReservationsRequest.getMaxResults() != null) {
            request.addParameter("MaxResults", StringUtils.fromInteger((Integer)describeHostReservationsRequest.getMaxResults()));
        }
        if (describeHostReservationsRequest.getNextToken() != null) {
            request.addParameter("NextToken", StringUtils.fromString((String)describeHostReservationsRequest.getNextToken()));
        }
        return request;
    }
}

