/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.DescribeAddressesRequest;
import com.amazonaws.services.ec2.model.Filter;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class DescribeAddressesRequestMarshaller
implements Marshaller<Request<DescribeAddressesRequest>, DescribeAddressesRequest> {
    public Request<DescribeAddressesRequest> marshall(DescribeAddressesRequest describeAddressesRequest) {
        SdkInternalList describeAddressesRequestAllocationIdsList;
        SdkInternalList describeAddressesRequestFiltersList;
        if (describeAddressesRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeAddressesRequest, "AmazonEC2");
        request.addParameter("Action", "DescribeAddresses");
        request.addParameter("Version", "2016-09-15");
        request.setHttpMethod(HttpMethodName.POST);
        SdkInternalList describeAddressesRequestPublicIpsList = (SdkInternalList)describeAddressesRequest.getPublicIps();
        if (!describeAddressesRequestPublicIpsList.isEmpty() || !describeAddressesRequestPublicIpsList.isAutoConstruct()) {
            int publicIpsListIndex = 1;
            for (Object describeAddressesRequestPublicIpsListValue : describeAddressesRequestPublicIpsList) {
                if (describeAddressesRequestPublicIpsListValue != null) {
                    request.addParameter("PublicIp." + publicIpsListIndex, StringUtils.fromString((String)describeAddressesRequestPublicIpsListValue));
                }
                ++publicIpsListIndex;
            }
        }
        if (!(describeAddressesRequestFiltersList = (SdkInternalList)describeAddressesRequest.getFilters()).isEmpty() || !describeAddressesRequestFiltersList.isAutoConstruct()) {
            int filtersListIndex = 1;
            for (Filter describeAddressesRequestFiltersListValue : describeAddressesRequestFiltersList) {
                SdkInternalList filterValuesList;
                if (describeAddressesRequestFiltersListValue.getName() != null) {
                    request.addParameter("Filter." + filtersListIndex + ".Name", StringUtils.fromString((String)describeAddressesRequestFiltersListValue.getName()));
                }
                if (!(filterValuesList = (SdkInternalList)describeAddressesRequestFiltersListValue.getValues()).isEmpty() || !filterValuesList.isAutoConstruct()) {
                    int valuesListIndex = 1;
                    for (String filterValuesListValue : filterValuesList) {
                        if (filterValuesListValue != null) {
                            request.addParameter("Filter." + filtersListIndex + ".Value." + valuesListIndex, StringUtils.fromString((String)filterValuesListValue));
                        }
                        ++valuesListIndex;
                    }
                }
                ++filtersListIndex;
            }
        }
        if (!(describeAddressesRequestAllocationIdsList = (SdkInternalList)describeAddressesRequest.getAllocationIds()).isEmpty() || !describeAddressesRequestAllocationIdsList.isAutoConstruct()) {
            int allocationIdsListIndex = 1;
            for (String describeAddressesRequestAllocationIdsListValue : describeAddressesRequestAllocationIdsList) {
                if (describeAddressesRequestAllocationIdsListValue != null) {
                    request.addParameter("AllocationId." + allocationIdsListIndex, StringUtils.fromString((String)describeAddressesRequestAllocationIdsListValue));
                }
                ++allocationIdsListIndex;
            }
        }
        return request;
    }
}

