/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.CreateTagsRequest;
import com.amazonaws.services.ec2.model.Tag;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class CreateTagsRequestMarshaller
implements Marshaller<Request<CreateTagsRequest>, CreateTagsRequest> {
    public Request<CreateTagsRequest> marshall(CreateTagsRequest createTagsRequest) {
        SdkInternalList createTagsRequestTagsList;
        if (createTagsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createTagsRequest, "AmazonEC2");
        request.addParameter("Action", "CreateTags");
        request.addParameter("Version", "2016-09-15");
        request.setHttpMethod(HttpMethodName.POST);
        SdkInternalList createTagsRequestResourcesList = (SdkInternalList)createTagsRequest.getResources();
        if (!createTagsRequestResourcesList.isEmpty() || !createTagsRequestResourcesList.isAutoConstruct()) {
            int resourcesListIndex = 1;
            for (String createTagsRequestResourcesListValue : createTagsRequestResourcesList) {
                if (createTagsRequestResourcesListValue != null) {
                    request.addParameter("ResourceId." + resourcesListIndex, StringUtils.fromString((String)createTagsRequestResourcesListValue));
                }
                ++resourcesListIndex;
            }
        }
        if (!(createTagsRequestTagsList = (SdkInternalList)createTagsRequest.getTags()).isEmpty() || !createTagsRequestTagsList.isAutoConstruct()) {
            int tagsListIndex = 1;
            for (Tag createTagsRequestTagsListValue : createTagsRequestTagsList) {
                if (createTagsRequestTagsListValue.getKey() != null) {
                    request.addParameter("Tag." + tagsListIndex + ".Key", StringUtils.fromString((String)createTagsRequestTagsListValue.getKey()));
                }
                if (createTagsRequestTagsListValue.getValue() != null) {
                    request.addParameter("Tag." + tagsListIndex + ".Value", StringUtils.fromString((String)createTagsRequestTagsListValue.getValue()));
                }
                ++tagsListIndex;
            }
        }
        return request;
    }
}

