/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.Request;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.DryRunSupportedRequest;
import com.amazonaws.services.ec2.model.FlowLogsResourceType;
import com.amazonaws.services.ec2.model.LogDestinationType;
import com.amazonaws.services.ec2.model.TrafficType;
import com.amazonaws.services.ec2.model.transform.CreateFlowLogsRequestMarshaller;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class CreateFlowLogsRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable,
DryRunSupportedRequest<CreateFlowLogsRequest> {
    private String clientToken;
    private String deliverLogsPermissionArn;
    private String logGroupName;
    private SdkInternalList<String> resourceIds;
    private String resourceType;
    private String trafficType;
    private String logDestinationType;
    private String logDestination;

    public void setClientToken(String clientToken) {
        this.clientToken = clientToken;
    }

    public String getClientToken() {
        return this.clientToken;
    }

    public CreateFlowLogsRequest withClientToken(String clientToken) {
        this.setClientToken(clientToken);
        return this;
    }

    public void setDeliverLogsPermissionArn(String deliverLogsPermissionArn) {
        this.deliverLogsPermissionArn = deliverLogsPermissionArn;
    }

    public String getDeliverLogsPermissionArn() {
        return this.deliverLogsPermissionArn;
    }

    public CreateFlowLogsRequest withDeliverLogsPermissionArn(String deliverLogsPermissionArn) {
        this.setDeliverLogsPermissionArn(deliverLogsPermissionArn);
        return this;
    }

    public void setLogGroupName(String logGroupName) {
        this.logGroupName = logGroupName;
    }

    public String getLogGroupName() {
        return this.logGroupName;
    }

    public CreateFlowLogsRequest withLogGroupName(String logGroupName) {
        this.setLogGroupName(logGroupName);
        return this;
    }

    public List<String> getResourceIds() {
        if (this.resourceIds == null) {
            this.resourceIds = new SdkInternalList();
        }
        return this.resourceIds;
    }

    public void setResourceIds(Collection<String> resourceIds) {
        if (resourceIds == null) {
            this.resourceIds = null;
            return;
        }
        this.resourceIds = new SdkInternalList(resourceIds);
    }

    public CreateFlowLogsRequest withResourceIds(String ... resourceIds) {
        if (this.resourceIds == null) {
            this.setResourceIds((Collection<String>)new SdkInternalList(resourceIds.length));
        }
        for (String ele : resourceIds) {
            this.resourceIds.add((Object)ele);
        }
        return this;
    }

    public CreateFlowLogsRequest withResourceIds(Collection<String> resourceIds) {
        this.setResourceIds(resourceIds);
        return this;
    }

    public void setResourceType(String resourceType) {
        this.resourceType = resourceType;
    }

    public String getResourceType() {
        return this.resourceType;
    }

    public CreateFlowLogsRequest withResourceType(String resourceType) {
        this.setResourceType(resourceType);
        return this;
    }

    public void setResourceType(FlowLogsResourceType resourceType) {
        this.withResourceType(resourceType);
    }

    public CreateFlowLogsRequest withResourceType(FlowLogsResourceType resourceType) {
        this.resourceType = resourceType.toString();
        return this;
    }

    public void setTrafficType(String trafficType) {
        this.trafficType = trafficType;
    }

    public String getTrafficType() {
        return this.trafficType;
    }

    public CreateFlowLogsRequest withTrafficType(String trafficType) {
        this.setTrafficType(trafficType);
        return this;
    }

    public void setTrafficType(TrafficType trafficType) {
        this.withTrafficType(trafficType);
    }

    public CreateFlowLogsRequest withTrafficType(TrafficType trafficType) {
        this.trafficType = trafficType.toString();
        return this;
    }

    public void setLogDestinationType(String logDestinationType) {
        this.logDestinationType = logDestinationType;
    }

    public String getLogDestinationType() {
        return this.logDestinationType;
    }

    public CreateFlowLogsRequest withLogDestinationType(String logDestinationType) {
        this.setLogDestinationType(logDestinationType);
        return this;
    }

    public void setLogDestinationType(LogDestinationType logDestinationType) {
        this.withLogDestinationType(logDestinationType);
    }

    public CreateFlowLogsRequest withLogDestinationType(LogDestinationType logDestinationType) {
        this.logDestinationType = logDestinationType.toString();
        return this;
    }

    public void setLogDestination(String logDestination) {
        this.logDestination = logDestination;
    }

    public String getLogDestination() {
        return this.logDestination;
    }

    public CreateFlowLogsRequest withLogDestination(String logDestination) {
        this.setLogDestination(logDestination);
        return this;
    }

    @Override
    public Request<CreateFlowLogsRequest> getDryRunRequest() {
        Request<CreateFlowLogsRequest> request = new CreateFlowLogsRequestMarshaller().marshall(this);
        request.addParameter("DryRun", Boolean.toString(true));
        return request;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getClientToken() != null) {
            sb.append("ClientToken: ").append(this.getClientToken()).append(",");
        }
        if (this.getDeliverLogsPermissionArn() != null) {
            sb.append("DeliverLogsPermissionArn: ").append(this.getDeliverLogsPermissionArn()).append(",");
        }
        if (this.getLogGroupName() != null) {
            sb.append("LogGroupName: ").append(this.getLogGroupName()).append(",");
        }
        if (this.getResourceIds() != null) {
            sb.append("ResourceIds: ").append(this.getResourceIds()).append(",");
        }
        if (this.getResourceType() != null) {
            sb.append("ResourceType: ").append(this.getResourceType()).append(",");
        }
        if (this.getTrafficType() != null) {
            sb.append("TrafficType: ").append(this.getTrafficType()).append(",");
        }
        if (this.getLogDestinationType() != null) {
            sb.append("LogDestinationType: ").append(this.getLogDestinationType()).append(",");
        }
        if (this.getLogDestination() != null) {
            sb.append("LogDestination: ").append(this.getLogDestination());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateFlowLogsRequest)) {
            return false;
        }
        CreateFlowLogsRequest other = (CreateFlowLogsRequest)obj;
        if (other.getClientToken() == null ^ this.getClientToken() == null) {
            return false;
        }
        if (other.getClientToken() != null && !other.getClientToken().equals(this.getClientToken())) {
            return false;
        }
        if (other.getDeliverLogsPermissionArn() == null ^ this.getDeliverLogsPermissionArn() == null) {
            return false;
        }
        if (other.getDeliverLogsPermissionArn() != null && !other.getDeliverLogsPermissionArn().equals(this.getDeliverLogsPermissionArn())) {
            return false;
        }
        if (other.getLogGroupName() == null ^ this.getLogGroupName() == null) {
            return false;
        }
        if (other.getLogGroupName() != null && !other.getLogGroupName().equals(this.getLogGroupName())) {
            return false;
        }
        if (other.getResourceIds() == null ^ this.getResourceIds() == null) {
            return false;
        }
        if (other.getResourceIds() != null && !other.getResourceIds().equals(this.getResourceIds())) {
            return false;
        }
        if (other.getResourceType() == null ^ this.getResourceType() == null) {
            return false;
        }
        if (other.getResourceType() != null && !other.getResourceType().equals(this.getResourceType())) {
            return false;
        }
        if (other.getTrafficType() == null ^ this.getTrafficType() == null) {
            return false;
        }
        if (other.getTrafficType() != null && !other.getTrafficType().equals(this.getTrafficType())) {
            return false;
        }
        if (other.getLogDestinationType() == null ^ this.getLogDestinationType() == null) {
            return false;
        }
        if (other.getLogDestinationType() != null && !other.getLogDestinationType().equals(this.getLogDestinationType())) {
            return false;
        }
        if (other.getLogDestination() == null ^ this.getLogDestination() == null) {
            return false;
        }
        return other.getLogDestination() == null || other.getLogDestination().equals(this.getLogDestination());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getClientToken() == null ? 0 : this.getClientToken().hashCode());
        hashCode = 31 * hashCode + (this.getDeliverLogsPermissionArn() == null ? 0 : this.getDeliverLogsPermissionArn().hashCode());
        hashCode = 31 * hashCode + (this.getLogGroupName() == null ? 0 : this.getLogGroupName().hashCode());
        hashCode = 31 * hashCode + (this.getResourceIds() == null ? 0 : this.getResourceIds().hashCode());
        hashCode = 31 * hashCode + (this.getResourceType() == null ? 0 : this.getResourceType().hashCode());
        hashCode = 31 * hashCode + (this.getTrafficType() == null ? 0 : this.getTrafficType().hashCode());
        hashCode = 31 * hashCode + (this.getLogDestinationType() == null ? 0 : this.getLogDestinationType().hashCode());
        hashCode = 31 * hashCode + (this.getLogDestination() == null ? 0 : this.getLogDestination().hashCode());
        return hashCode;
    }

    public CreateFlowLogsRequest clone() {
        return (CreateFlowLogsRequest)super.clone();
    }
}

