/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.DescribeDhcpOptionsRequest;
import com.amazonaws.services.ec2.model.Filter;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class DescribeDhcpOptionsRequestMarshaller
implements Marshaller<Request<DescribeDhcpOptionsRequest>, DescribeDhcpOptionsRequest> {
    public Request<DescribeDhcpOptionsRequest> marshall(DescribeDhcpOptionsRequest describeDhcpOptionsRequest) {
        SdkInternalList describeDhcpOptionsRequestFiltersList;
        if (describeDhcpOptionsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeDhcpOptionsRequest, "AmazonEC2");
        request.addParameter("Action", "DescribeDhcpOptions");
        request.addParameter("Version", "2016-09-15");
        request.setHttpMethod(HttpMethodName.POST);
        SdkInternalList describeDhcpOptionsRequestDhcpOptionsIdsList = (SdkInternalList)describeDhcpOptionsRequest.getDhcpOptionsIds();
        if (!describeDhcpOptionsRequestDhcpOptionsIdsList.isEmpty() || !describeDhcpOptionsRequestDhcpOptionsIdsList.isAutoConstruct()) {
            int dhcpOptionsIdsListIndex = 1;
            for (String describeDhcpOptionsRequestDhcpOptionsIdsListValue : describeDhcpOptionsRequestDhcpOptionsIdsList) {
                if (describeDhcpOptionsRequestDhcpOptionsIdsListValue != null) {
                    request.addParameter("DhcpOptionsId." + dhcpOptionsIdsListIndex, StringUtils.fromString((String)describeDhcpOptionsRequestDhcpOptionsIdsListValue));
                }
                ++dhcpOptionsIdsListIndex;
            }
        }
        if (!(describeDhcpOptionsRequestFiltersList = (SdkInternalList)describeDhcpOptionsRequest.getFilters()).isEmpty() || !describeDhcpOptionsRequestFiltersList.isAutoConstruct()) {
            int filtersListIndex = 1;
            for (Filter describeDhcpOptionsRequestFiltersListValue : describeDhcpOptionsRequestFiltersList) {
                SdkInternalList filterValuesList;
                if (describeDhcpOptionsRequestFiltersListValue.getName() != null) {
                    request.addParameter("Filter." + filtersListIndex + ".Name", StringUtils.fromString((String)describeDhcpOptionsRequestFiltersListValue.getName()));
                }
                if (!(filterValuesList = (SdkInternalList)describeDhcpOptionsRequestFiltersListValue.getValues()).isEmpty() || !filterValuesList.isAutoConstruct()) {
                    int valuesListIndex = 1;
                    for (String filterValuesListValue : filterValuesList) {
                        if (filterValuesListValue != null) {
                            request.addParameter("Filter." + filtersListIndex + ".Value." + valuesListIndex, StringUtils.fromString((String)filterValuesListValue));
                        }
                        ++valuesListIndex;
                    }
                }
                ++filtersListIndex;
            }
        }
        return request;
    }
}

