/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.ec2.model.ModifyVpcPeeringConnectionOptionsRequest;
import com.amazonaws.services.ec2.model.PeeringConnectionOptionsRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class ModifyVpcPeeringConnectionOptionsRequestMarshaller
implements Marshaller<Request<ModifyVpcPeeringConnectionOptionsRequest>, ModifyVpcPeeringConnectionOptionsRequest> {
    public Request<ModifyVpcPeeringConnectionOptionsRequest> marshall(ModifyVpcPeeringConnectionOptionsRequest modifyVpcPeeringConnectionOptionsRequest) {
        PeeringConnectionOptionsRequest accepterPeeringConnectionOptions;
        PeeringConnectionOptionsRequest requesterPeeringConnectionOptions;
        if (modifyVpcPeeringConnectionOptionsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)modifyVpcPeeringConnectionOptionsRequest, "AmazonEC2");
        request.addParameter("Action", "ModifyVpcPeeringConnectionOptions");
        request.addParameter("Version", "2016-09-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (modifyVpcPeeringConnectionOptionsRequest.getVpcPeeringConnectionId() != null) {
            request.addParameter("VpcPeeringConnectionId", StringUtils.fromString((String)modifyVpcPeeringConnectionOptionsRequest.getVpcPeeringConnectionId()));
        }
        if ((requesterPeeringConnectionOptions = modifyVpcPeeringConnectionOptionsRequest.getRequesterPeeringConnectionOptions()) != null) {
            if (requesterPeeringConnectionOptions.getAllowEgressFromLocalClassicLinkToRemoteVpc() != null) {
                request.addParameter("RequesterPeeringConnectionOptions.AllowEgressFromLocalClassicLinkToRemoteVpc", StringUtils.fromBoolean((Boolean)requesterPeeringConnectionOptions.getAllowEgressFromLocalClassicLinkToRemoteVpc()));
            }
            if (requesterPeeringConnectionOptions.getAllowEgressFromLocalVpcToRemoteClassicLink() != null) {
                request.addParameter("RequesterPeeringConnectionOptions.AllowEgressFromLocalVpcToRemoteClassicLink", StringUtils.fromBoolean((Boolean)requesterPeeringConnectionOptions.getAllowEgressFromLocalVpcToRemoteClassicLink()));
            }
            if (requesterPeeringConnectionOptions.getAllowDnsResolutionFromRemoteVpc() != null) {
                request.addParameter("RequesterPeeringConnectionOptions.AllowDnsResolutionFromRemoteVpc", StringUtils.fromBoolean((Boolean)requesterPeeringConnectionOptions.getAllowDnsResolutionFromRemoteVpc()));
            }
        }
        if ((accepterPeeringConnectionOptions = modifyVpcPeeringConnectionOptionsRequest.getAccepterPeeringConnectionOptions()) != null) {
            if (accepterPeeringConnectionOptions.getAllowEgressFromLocalClassicLinkToRemoteVpc() != null) {
                request.addParameter("AccepterPeeringConnectionOptions.AllowEgressFromLocalClassicLinkToRemoteVpc", StringUtils.fromBoolean((Boolean)accepterPeeringConnectionOptions.getAllowEgressFromLocalClassicLinkToRemoteVpc()));
            }
            if (accepterPeeringConnectionOptions.getAllowEgressFromLocalVpcToRemoteClassicLink() != null) {
                request.addParameter("AccepterPeeringConnectionOptions.AllowEgressFromLocalVpcToRemoteClassicLink", StringUtils.fromBoolean((Boolean)accepterPeeringConnectionOptions.getAllowEgressFromLocalVpcToRemoteClassicLink()));
            }
            if (accepterPeeringConnectionOptions.getAllowDnsResolutionFromRemoteVpc() != null) {
                request.addParameter("AccepterPeeringConnectionOptions.AllowDnsResolutionFromRemoteVpc", StringUtils.fromBoolean((Boolean)accepterPeeringConnectionOptions.getAllowDnsResolutionFromRemoteVpc()));
            }
        }
        return request;
    }
}

