/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.DescribeHostReservationsRequest;
import com.amazonaws.services.ec2.model.Filter;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class DescribeHostReservationsRequestMarshaller
implements Marshaller<Request<DescribeHostReservationsRequest>, DescribeHostReservationsRequest> {
    public Request<DescribeHostReservationsRequest> marshall(DescribeHostReservationsRequest describeHostReservationsRequest) {
        SdkInternalList filterList;
        if (describeHostReservationsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeHostReservationsRequest, "AmazonEC2");
        request.addParameter("Action", "DescribeHostReservations");
        request.addParameter("Version", "2016-09-15");
        request.setHttpMethod(HttpMethodName.POST);
        SdkInternalList hostReservationIdSetList = (SdkInternalList)describeHostReservationsRequest.getHostReservationIdSet();
        if (!hostReservationIdSetList.isEmpty() || !hostReservationIdSetList.isAutoConstruct()) {
            int hostReservationIdSetListIndex = 1;
            for (String hostReservationIdSetListValue : hostReservationIdSetList) {
                if (hostReservationIdSetListValue != null) {
                    request.addParameter("HostReservationIdSet." + hostReservationIdSetListIndex, StringUtils.fromString((String)hostReservationIdSetListValue));
                }
                ++hostReservationIdSetListIndex;
            }
        }
        if (!(filterList = (SdkInternalList)describeHostReservationsRequest.getFilter()).isEmpty() || !filterList.isAutoConstruct()) {
            int filterListIndex = 1;
            for (Filter filterListValue : filterList) {
                SdkInternalList valuesList;
                if (filterListValue.getName() != null) {
                    request.addParameter("Filter." + filterListIndex + ".Name", StringUtils.fromString((String)filterListValue.getName()));
                }
                if (!(valuesList = (SdkInternalList)filterListValue.getValues()).isEmpty() || !valuesList.isAutoConstruct()) {
                    int valuesListIndex = 1;
                    for (String valuesListValue : valuesList) {
                        if (valuesListValue != null) {
                            request.addParameter("Filter." + filterListIndex + ".Value." + valuesListIndex, StringUtils.fromString((String)valuesListValue));
                        }
                        ++valuesListIndex;
                    }
                }
                ++filterListIndex;
            }
        }
        if (describeHostReservationsRequest.getMaxResults() != null) {
            request.addParameter("MaxResults", StringUtils.fromInteger((Integer)describeHostReservationsRequest.getMaxResults()));
        }
        if (describeHostReservationsRequest.getNextToken() != null) {
            request.addParameter("NextToken", StringUtils.fromString((String)describeHostReservationsRequest.getNextToken()));
        }
        return request;
    }
}

