/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.DeleteFlowLogsRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class DeleteFlowLogsRequestMarshaller
implements Marshaller<Request<DeleteFlowLogsRequest>, DeleteFlowLogsRequest> {
    public Request<DeleteFlowLogsRequest> marshall(DeleteFlowLogsRequest deleteFlowLogsRequest) {
        if (deleteFlowLogsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)deleteFlowLogsRequest, "AmazonEC2");
        request.addParameter("Action", "DeleteFlowLogs");
        request.addParameter("Version", "2016-04-01");
        request.setHttpMethod(HttpMethodName.POST);
        SdkInternalList flowLogIdsList = (SdkInternalList)deleteFlowLogsRequest.getFlowLogIds();
        if (!flowLogIdsList.isEmpty() || !flowLogIdsList.isAutoConstruct()) {
            int flowLogIdsListIndex = 1;
            for (String flowLogIdsListValue : flowLogIdsList) {
                if (flowLogIdsListValue != null) {
                    request.addParameter("FlowLogId." + flowLogIdsListIndex, StringUtils.fromString((String)flowLogIdsListValue));
                }
                ++flowLogIdsListIndex;
            }
        }
        return request;
    }
}

