/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.DescribeVpcsRequest;
import com.amazonaws.services.ec2.model.Filter;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class DescribeVpcsRequestMarshaller
implements Marshaller<Request<DescribeVpcsRequest>, DescribeVpcsRequest> {
    public Request<DescribeVpcsRequest> marshall(DescribeVpcsRequest describeVpcsRequest) {
        SdkInternalList describeVpcsRequestVpcIdsList;
        if (describeVpcsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeVpcsRequest, "AmazonEC2");
        request.addParameter("Action", "DescribeVpcs");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        SdkInternalList describeVpcsRequestFiltersList = (SdkInternalList)describeVpcsRequest.getFilters();
        if (!describeVpcsRequestFiltersList.isEmpty() || !describeVpcsRequestFiltersList.isAutoConstruct()) {
            int filtersListIndex = 1;
            for (Filter describeVpcsRequestFiltersListValue : describeVpcsRequestFiltersList) {
                SdkInternalList filterValuesList;
                if (describeVpcsRequestFiltersListValue.getName() != null) {
                    request.addParameter("Filter." + filtersListIndex + ".Name", StringUtils.fromString((String)describeVpcsRequestFiltersListValue.getName()));
                }
                if (!(filterValuesList = (SdkInternalList)describeVpcsRequestFiltersListValue.getValues()).isEmpty() || !filterValuesList.isAutoConstruct()) {
                    int valuesListIndex = 1;
                    for (String filterValuesListValue : filterValuesList) {
                        if (filterValuesListValue != null) {
                            request.addParameter("Filter." + filtersListIndex + ".Value." + valuesListIndex, StringUtils.fromString((String)filterValuesListValue));
                        }
                        ++valuesListIndex;
                    }
                }
                ++filtersListIndex;
            }
        }
        if (!(describeVpcsRequestVpcIdsList = (SdkInternalList)describeVpcsRequest.getVpcIds()).isEmpty() || !describeVpcsRequestVpcIdsList.isAutoConstruct()) {
            int vpcIdsListIndex = 1;
            for (String describeVpcsRequestVpcIdsListValue : describeVpcsRequestVpcIdsList) {
                if (describeVpcsRequestVpcIdsListValue != null) {
                    request.addParameter("VpcId." + vpcIdsListIndex, StringUtils.fromString((String)describeVpcsRequestVpcIdsListValue));
                }
                ++vpcIdsListIndex;
            }
        }
        return request;
    }
}

