/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.AuthorizeSecurityGroupEgressRequest;
import com.amazonaws.services.ec2.model.IpPermission;
import com.amazonaws.services.ec2.model.IpRange;
import com.amazonaws.services.ec2.model.Ipv6Range;
import com.amazonaws.services.ec2.model.PrefixListId;
import com.amazonaws.services.ec2.model.UserIdGroupPair;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class AuthorizeSecurityGroupEgressRequestMarshaller
implements Marshaller<Request<AuthorizeSecurityGroupEgressRequest>, AuthorizeSecurityGroupEgressRequest> {
    public Request<AuthorizeSecurityGroupEgressRequest> marshall(AuthorizeSecurityGroupEgressRequest authorizeSecurityGroupEgressRequest) {
        SdkInternalList authorizeSecurityGroupEgressRequestIpPermissionsList;
        if (authorizeSecurityGroupEgressRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)authorizeSecurityGroupEgressRequest, "AmazonEC2");
        request.addParameter("Action", "AuthorizeSecurityGroupEgress");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (authorizeSecurityGroupEgressRequest.getGroupId() != null) {
            request.addParameter("GroupId", StringUtils.fromString((String)authorizeSecurityGroupEgressRequest.getGroupId()));
        }
        if (!(authorizeSecurityGroupEgressRequestIpPermissionsList = (SdkInternalList)authorizeSecurityGroupEgressRequest.getIpPermissions()).isEmpty() || !authorizeSecurityGroupEgressRequestIpPermissionsList.isAutoConstruct()) {
            int ipPermissionsListIndex = 1;
            for (IpPermission authorizeSecurityGroupEgressRequestIpPermissionsListValue : authorizeSecurityGroupEgressRequestIpPermissionsList) {
                SdkInternalList ipPermissionIpv4RangesList;
                SdkInternalList ipPermissionUserIdGroupPairsList;
                SdkInternalList ipPermissionPrefixListIdsList;
                SdkInternalList ipPermissionIpv6RangesList;
                if (authorizeSecurityGroupEgressRequestIpPermissionsListValue.getFromPort() != null) {
                    request.addParameter("IpPermissions." + ipPermissionsListIndex + ".FromPort", StringUtils.fromInteger((Integer)authorizeSecurityGroupEgressRequestIpPermissionsListValue.getFromPort()));
                }
                if (authorizeSecurityGroupEgressRequestIpPermissionsListValue.getIpProtocol() != null) {
                    request.addParameter("IpPermissions." + ipPermissionsListIndex + ".IpProtocol", StringUtils.fromString((String)authorizeSecurityGroupEgressRequestIpPermissionsListValue.getIpProtocol()));
                }
                if (!(ipPermissionIpv6RangesList = (SdkInternalList)authorizeSecurityGroupEgressRequestIpPermissionsListValue.getIpv6Ranges()).isEmpty() || !ipPermissionIpv6RangesList.isAutoConstruct()) {
                    int ipv6RangesListIndex = 1;
                    for (Object ipPermissionIpv6RangesListValue : ipPermissionIpv6RangesList) {
                        if (((Ipv6Range)ipPermissionIpv6RangesListValue).getCidrIpv6() != null) {
                            request.addParameter("IpPermissions." + ipPermissionsListIndex + ".Ipv6Ranges." + ipv6RangesListIndex + ".CidrIpv6", StringUtils.fromString((String)((Ipv6Range)ipPermissionIpv6RangesListValue).getCidrIpv6()));
                        }
                        ++ipv6RangesListIndex;
                    }
                }
                if (!(ipPermissionPrefixListIdsList = (SdkInternalList)authorizeSecurityGroupEgressRequestIpPermissionsListValue.getPrefixListIds()).isEmpty() || !ipPermissionPrefixListIdsList.isAutoConstruct()) {
                    Object ipPermissionIpv6RangesListValue;
                    int prefixListIdsListIndex = 1;
                    ipPermissionIpv6RangesListValue = ipPermissionPrefixListIdsList.iterator();
                    while (ipPermissionIpv6RangesListValue.hasNext()) {
                        PrefixListId ipPermissionPrefixListIdsListValue = (PrefixListId)ipPermissionIpv6RangesListValue.next();
                        if (ipPermissionPrefixListIdsListValue.getPrefixListId() != null) {
                            request.addParameter("IpPermissions." + ipPermissionsListIndex + ".PrefixListIds." + prefixListIdsListIndex + ".PrefixListId", StringUtils.fromString((String)ipPermissionPrefixListIdsListValue.getPrefixListId()));
                        }
                        ++prefixListIdsListIndex;
                    }
                }
                if (authorizeSecurityGroupEgressRequestIpPermissionsListValue.getToPort() != null) {
                    request.addParameter("IpPermissions." + ipPermissionsListIndex + ".ToPort", StringUtils.fromInteger((Integer)authorizeSecurityGroupEgressRequestIpPermissionsListValue.getToPort()));
                }
                if (!(ipPermissionUserIdGroupPairsList = (SdkInternalList)authorizeSecurityGroupEgressRequestIpPermissionsListValue.getUserIdGroupPairs()).isEmpty() || !ipPermissionUserIdGroupPairsList.isAutoConstruct()) {
                    int userIdGroupPairsListIndex = 1;
                    for (UserIdGroupPair ipPermissionUserIdGroupPairsListValue : ipPermissionUserIdGroupPairsList) {
                        if (ipPermissionUserIdGroupPairsListValue.getGroupId() != null) {
                            request.addParameter("IpPermissions." + ipPermissionsListIndex + ".Groups." + userIdGroupPairsListIndex + ".GroupId", StringUtils.fromString((String)ipPermissionUserIdGroupPairsListValue.getGroupId()));
                        }
                        if (ipPermissionUserIdGroupPairsListValue.getGroupName() != null) {
                            request.addParameter("IpPermissions." + ipPermissionsListIndex + ".Groups." + userIdGroupPairsListIndex + ".GroupName", StringUtils.fromString((String)ipPermissionUserIdGroupPairsListValue.getGroupName()));
                        }
                        if (ipPermissionUserIdGroupPairsListValue.getPeeringStatus() != null) {
                            request.addParameter("IpPermissions." + ipPermissionsListIndex + ".Groups." + userIdGroupPairsListIndex + ".PeeringStatus", StringUtils.fromString((String)ipPermissionUserIdGroupPairsListValue.getPeeringStatus()));
                        }
                        if (ipPermissionUserIdGroupPairsListValue.getUserId() != null) {
                            request.addParameter("IpPermissions." + ipPermissionsListIndex + ".Groups." + userIdGroupPairsListIndex + ".UserId", StringUtils.fromString((String)ipPermissionUserIdGroupPairsListValue.getUserId()));
                        }
                        if (ipPermissionUserIdGroupPairsListValue.getVpcId() != null) {
                            request.addParameter("IpPermissions." + ipPermissionsListIndex + ".Groups." + userIdGroupPairsListIndex + ".VpcId", StringUtils.fromString((String)ipPermissionUserIdGroupPairsListValue.getVpcId()));
                        }
                        if (ipPermissionUserIdGroupPairsListValue.getVpcPeeringConnectionId() != null) {
                            request.addParameter("IpPermissions." + ipPermissionsListIndex + ".Groups." + userIdGroupPairsListIndex + ".VpcPeeringConnectionId", StringUtils.fromString((String)ipPermissionUserIdGroupPairsListValue.getVpcPeeringConnectionId()));
                        }
                        ++userIdGroupPairsListIndex;
                    }
                }
                if (!(ipPermissionIpv4RangesList = (SdkInternalList)authorizeSecurityGroupEgressRequestIpPermissionsListValue.getIpv4Ranges()).isEmpty() || !ipPermissionIpv4RangesList.isAutoConstruct()) {
                    int ipv4RangesListIndex = 1;
                    for (IpRange ipPermissionIpv4RangesListValue : ipPermissionIpv4RangesList) {
                        if (ipPermissionIpv4RangesListValue.getCidrIp() != null) {
                            request.addParameter("IpPermissions." + ipPermissionsListIndex + ".IpRanges." + ipv4RangesListIndex + ".CidrIp", StringUtils.fromString((String)ipPermissionIpv4RangesListValue.getCidrIp()));
                        }
                        ++ipv4RangesListIndex;
                    }
                }
                ++ipPermissionsListIndex;
            }
        }
        if (authorizeSecurityGroupEgressRequest.getCidrIp() != null) {
            request.addParameter("CidrIp", StringUtils.fromString((String)authorizeSecurityGroupEgressRequest.getCidrIp()));
        }
        if (authorizeSecurityGroupEgressRequest.getFromPort() != null) {
            request.addParameter("FromPort", StringUtils.fromInteger((Integer)authorizeSecurityGroupEgressRequest.getFromPort()));
        }
        if (authorizeSecurityGroupEgressRequest.getIpProtocol() != null) {
            request.addParameter("IpProtocol", StringUtils.fromString((String)authorizeSecurityGroupEgressRequest.getIpProtocol()));
        }
        if (authorizeSecurityGroupEgressRequest.getToPort() != null) {
            request.addParameter("ToPort", StringUtils.fromInteger((Integer)authorizeSecurityGroupEgressRequest.getToPort()));
        }
        if (authorizeSecurityGroupEgressRequest.getSourceSecurityGroupName() != null) {
            request.addParameter("SourceSecurityGroupName", StringUtils.fromString((String)authorizeSecurityGroupEgressRequest.getSourceSecurityGroupName()));
        }
        if (authorizeSecurityGroupEgressRequest.getSourceSecurityGroupOwnerId() != null) {
            request.addParameter("SourceSecurityGroupOwnerId", StringUtils.fromString((String)authorizeSecurityGroupEgressRequest.getSourceSecurityGroupOwnerId()));
        }
        return request;
    }
}

