/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model;

import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.ec2.model.AllocationStrategy;
import com.amazonaws.services.ec2.model.ExcessCapacityTerminationPolicy;
import com.amazonaws.services.ec2.model.SpotFleetLaunchSpecification;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class SpotFleetRequestConfigData
implements Serializable,
Cloneable {
    private String clientToken;
    private String spotPrice;
    private Integer targetCapacity;
    private Date validFrom;
    private Date validUntil;
    private Boolean terminateInstancesWithExpiration;
    private String iamFleetRole;
    private ListWithAutoConstructFlag<SpotFleetLaunchSpecification> launchSpecifications;
    private String excessCapacityTerminationPolicy;
    private String allocationStrategy;

    public String getClientToken() {
        return this.clientToken;
    }

    public void setClientToken(String clientToken) {
        this.clientToken = clientToken;
    }

    public SpotFleetRequestConfigData withClientToken(String clientToken) {
        this.clientToken = clientToken;
        return this;
    }

    public String getSpotPrice() {
        return this.spotPrice;
    }

    public void setSpotPrice(String spotPrice) {
        this.spotPrice = spotPrice;
    }

    public SpotFleetRequestConfigData withSpotPrice(String spotPrice) {
        this.spotPrice = spotPrice;
        return this;
    }

    public Integer getTargetCapacity() {
        return this.targetCapacity;
    }

    public void setTargetCapacity(Integer targetCapacity) {
        this.targetCapacity = targetCapacity;
    }

    public SpotFleetRequestConfigData withTargetCapacity(Integer targetCapacity) {
        this.targetCapacity = targetCapacity;
        return this;
    }

    public Date getValidFrom() {
        return this.validFrom;
    }

    public void setValidFrom(Date validFrom) {
        this.validFrom = validFrom;
    }

    public SpotFleetRequestConfigData withValidFrom(Date validFrom) {
        this.validFrom = validFrom;
        return this;
    }

    public Date getValidUntil() {
        return this.validUntil;
    }

    public void setValidUntil(Date validUntil) {
        this.validUntil = validUntil;
    }

    public SpotFleetRequestConfigData withValidUntil(Date validUntil) {
        this.validUntil = validUntil;
        return this;
    }

    public Boolean isTerminateInstancesWithExpiration() {
        return this.terminateInstancesWithExpiration;
    }

    public void setTerminateInstancesWithExpiration(Boolean terminateInstancesWithExpiration) {
        this.terminateInstancesWithExpiration = terminateInstancesWithExpiration;
    }

    public SpotFleetRequestConfigData withTerminateInstancesWithExpiration(Boolean terminateInstancesWithExpiration) {
        this.terminateInstancesWithExpiration = terminateInstancesWithExpiration;
        return this;
    }

    public Boolean getTerminateInstancesWithExpiration() {
        return this.terminateInstancesWithExpiration;
    }

    public String getIamFleetRole() {
        return this.iamFleetRole;
    }

    public void setIamFleetRole(String iamFleetRole) {
        this.iamFleetRole = iamFleetRole;
    }

    public SpotFleetRequestConfigData withIamFleetRole(String iamFleetRole) {
        this.iamFleetRole = iamFleetRole;
        return this;
    }

    public List<SpotFleetLaunchSpecification> getLaunchSpecifications() {
        if (this.launchSpecifications == null) {
            this.launchSpecifications = new ListWithAutoConstructFlag();
            this.launchSpecifications.setAutoConstruct(true);
        }
        return this.launchSpecifications;
    }

    public void setLaunchSpecifications(Collection<SpotFleetLaunchSpecification> launchSpecifications) {
        if (launchSpecifications == null) {
            this.launchSpecifications = null;
            return;
        }
        ListWithAutoConstructFlag launchSpecificationsCopy = new ListWithAutoConstructFlag(launchSpecifications.size());
        launchSpecificationsCopy.addAll(launchSpecifications);
        this.launchSpecifications = launchSpecificationsCopy;
    }

    public SpotFleetRequestConfigData withLaunchSpecifications(SpotFleetLaunchSpecification ... launchSpecifications) {
        if (this.getLaunchSpecifications() == null) {
            this.setLaunchSpecifications(new ArrayList<SpotFleetLaunchSpecification>(launchSpecifications.length));
        }
        for (SpotFleetLaunchSpecification value : launchSpecifications) {
            this.getLaunchSpecifications().add(value);
        }
        return this;
    }

    public SpotFleetRequestConfigData withLaunchSpecifications(Collection<SpotFleetLaunchSpecification> launchSpecifications) {
        if (launchSpecifications == null) {
            this.launchSpecifications = null;
        } else {
            ListWithAutoConstructFlag launchSpecificationsCopy = new ListWithAutoConstructFlag(launchSpecifications.size());
            launchSpecificationsCopy.addAll(launchSpecifications);
            this.launchSpecifications = launchSpecificationsCopy;
        }
        return this;
    }

    public String getExcessCapacityTerminationPolicy() {
        return this.excessCapacityTerminationPolicy;
    }

    public void setExcessCapacityTerminationPolicy(String excessCapacityTerminationPolicy) {
        this.excessCapacityTerminationPolicy = excessCapacityTerminationPolicy;
    }

    public SpotFleetRequestConfigData withExcessCapacityTerminationPolicy(String excessCapacityTerminationPolicy) {
        this.excessCapacityTerminationPolicy = excessCapacityTerminationPolicy;
        return this;
    }

    public void setExcessCapacityTerminationPolicy(ExcessCapacityTerminationPolicy excessCapacityTerminationPolicy) {
        this.excessCapacityTerminationPolicy = excessCapacityTerminationPolicy.toString();
    }

    public SpotFleetRequestConfigData withExcessCapacityTerminationPolicy(ExcessCapacityTerminationPolicy excessCapacityTerminationPolicy) {
        this.excessCapacityTerminationPolicy = excessCapacityTerminationPolicy.toString();
        return this;
    }

    public String getAllocationStrategy() {
        return this.allocationStrategy;
    }

    public void setAllocationStrategy(String allocationStrategy) {
        this.allocationStrategy = allocationStrategy;
    }

    public SpotFleetRequestConfigData withAllocationStrategy(String allocationStrategy) {
        this.allocationStrategy = allocationStrategy;
        return this;
    }

    public void setAllocationStrategy(AllocationStrategy allocationStrategy) {
        this.allocationStrategy = allocationStrategy.toString();
    }

    public SpotFleetRequestConfigData withAllocationStrategy(AllocationStrategy allocationStrategy) {
        this.allocationStrategy = allocationStrategy.toString();
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getClientToken() != null) {
            sb.append("ClientToken: " + this.getClientToken() + ",");
        }
        if (this.getSpotPrice() != null) {
            sb.append("SpotPrice: " + this.getSpotPrice() + ",");
        }
        if (this.getTargetCapacity() != null) {
            sb.append("TargetCapacity: " + this.getTargetCapacity() + ",");
        }
        if (this.getValidFrom() != null) {
            sb.append("ValidFrom: " + this.getValidFrom() + ",");
        }
        if (this.getValidUntil() != null) {
            sb.append("ValidUntil: " + this.getValidUntil() + ",");
        }
        if (this.isTerminateInstancesWithExpiration() != null) {
            sb.append("TerminateInstancesWithExpiration: " + this.isTerminateInstancesWithExpiration() + ",");
        }
        if (this.getIamFleetRole() != null) {
            sb.append("IamFleetRole: " + this.getIamFleetRole() + ",");
        }
        if (this.getLaunchSpecifications() != null) {
            sb.append("LaunchSpecifications: " + this.getLaunchSpecifications() + ",");
        }
        if (this.getExcessCapacityTerminationPolicy() != null) {
            sb.append("ExcessCapacityTerminationPolicy: " + this.getExcessCapacityTerminationPolicy() + ",");
        }
        if (this.getAllocationStrategy() != null) {
            sb.append("AllocationStrategy: " + this.getAllocationStrategy());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getClientToken() == null ? 0 : this.getClientToken().hashCode());
        hashCode = 31 * hashCode + (this.getSpotPrice() == null ? 0 : this.getSpotPrice().hashCode());
        hashCode = 31 * hashCode + (this.getTargetCapacity() == null ? 0 : this.getTargetCapacity().hashCode());
        hashCode = 31 * hashCode + (this.getValidFrom() == null ? 0 : this.getValidFrom().hashCode());
        hashCode = 31 * hashCode + (this.getValidUntil() == null ? 0 : this.getValidUntil().hashCode());
        hashCode = 31 * hashCode + (this.isTerminateInstancesWithExpiration() == null ? 0 : this.isTerminateInstancesWithExpiration().hashCode());
        hashCode = 31 * hashCode + (this.getIamFleetRole() == null ? 0 : this.getIamFleetRole().hashCode());
        hashCode = 31 * hashCode + (this.getLaunchSpecifications() == null ? 0 : this.getLaunchSpecifications().hashCode());
        hashCode = 31 * hashCode + (this.getExcessCapacityTerminationPolicy() == null ? 0 : this.getExcessCapacityTerminationPolicy().hashCode());
        hashCode = 31 * hashCode + (this.getAllocationStrategy() == null ? 0 : this.getAllocationStrategy().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SpotFleetRequestConfigData)) {
            return false;
        }
        SpotFleetRequestConfigData other = (SpotFleetRequestConfigData)obj;
        if (other.getClientToken() == null ^ this.getClientToken() == null) {
            return false;
        }
        if (other.getClientToken() != null && !other.getClientToken().equals(this.getClientToken())) {
            return false;
        }
        if (other.getSpotPrice() == null ^ this.getSpotPrice() == null) {
            return false;
        }
        if (other.getSpotPrice() != null && !other.getSpotPrice().equals(this.getSpotPrice())) {
            return false;
        }
        if (other.getTargetCapacity() == null ^ this.getTargetCapacity() == null) {
            return false;
        }
        if (other.getTargetCapacity() != null && !other.getTargetCapacity().equals(this.getTargetCapacity())) {
            return false;
        }
        if (other.getValidFrom() == null ^ this.getValidFrom() == null) {
            return false;
        }
        if (other.getValidFrom() != null && !other.getValidFrom().equals(this.getValidFrom())) {
            return false;
        }
        if (other.getValidUntil() == null ^ this.getValidUntil() == null) {
            return false;
        }
        if (other.getValidUntil() != null && !other.getValidUntil().equals(this.getValidUntil())) {
            return false;
        }
        if (other.isTerminateInstancesWithExpiration() == null ^ this.isTerminateInstancesWithExpiration() == null) {
            return false;
        }
        if (other.isTerminateInstancesWithExpiration() != null && !other.isTerminateInstancesWithExpiration().equals(this.isTerminateInstancesWithExpiration())) {
            return false;
        }
        if (other.getIamFleetRole() == null ^ this.getIamFleetRole() == null) {
            return false;
        }
        if (other.getIamFleetRole() != null && !other.getIamFleetRole().equals(this.getIamFleetRole())) {
            return false;
        }
        if (other.getLaunchSpecifications() == null ^ this.getLaunchSpecifications() == null) {
            return false;
        }
        if (other.getLaunchSpecifications() != null && !other.getLaunchSpecifications().equals(this.getLaunchSpecifications())) {
            return false;
        }
        if (other.getExcessCapacityTerminationPolicy() == null ^ this.getExcessCapacityTerminationPolicy() == null) {
            return false;
        }
        if (other.getExcessCapacityTerminationPolicy() != null && !other.getExcessCapacityTerminationPolicy().equals(this.getExcessCapacityTerminationPolicy())) {
            return false;
        }
        if (other.getAllocationStrategy() == null ^ this.getAllocationStrategy() == null) {
            return false;
        }
        return other.getAllocationStrategy() == null || other.getAllocationStrategy().equals(this.getAllocationStrategy());
    }

    public SpotFleetRequestConfigData clone() {
        try {
            return (SpotFleetRequestConfigData)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

