/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.ec2.model.DescribeSpotFleetRequestsRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

public class DescribeSpotFleetRequestsRequestMarshaller
implements Marshaller<Request<DescribeSpotFleetRequestsRequest>, DescribeSpotFleetRequestsRequest> {
    public Request<DescribeSpotFleetRequestsRequest> marshall(DescribeSpotFleetRequestsRequest describeSpotFleetRequestsRequest) {
        if (describeSpotFleetRequestsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeSpotFleetRequestsRequest, "AmazonEC2");
        request.addParameter("Action", "DescribeSpotFleetRequests");
        request.addParameter("Version", "2015-04-15");
        List<String> spotFleetRequestIdsList = describeSpotFleetRequestsRequest.getSpotFleetRequestIds();
        int spotFleetRequestIdsListIndex = 1;
        for (String spotFleetRequestIdsListValue : spotFleetRequestIdsList) {
            if (spotFleetRequestIdsListValue != null) {
                request.addParameter("SpotFleetRequestId." + spotFleetRequestIdsListIndex, StringUtils.fromString((String)spotFleetRequestIdsListValue));
            }
            ++spotFleetRequestIdsListIndex;
        }
        if (describeSpotFleetRequestsRequest.getNextToken() != null) {
            request.addParameter("NextToken", StringUtils.fromString((String)describeSpotFleetRequestsRequest.getNextToken()));
        }
        if (describeSpotFleetRequestsRequest.getMaxResults() != null) {
            request.addParameter("MaxResults", StringUtils.fromInteger((Integer)describeSpotFleetRequestsRequest.getMaxResults()));
        }
        return request;
    }
}

