/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.ec2.model.DescribeVpcPeeringConnectionsRequest;
import com.amazonaws.services.ec2.model.Filter;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

public class DescribeVpcPeeringConnectionsRequestMarshaller
implements Marshaller<Request<DescribeVpcPeeringConnectionsRequest>, DescribeVpcPeeringConnectionsRequest> {
    public Request<DescribeVpcPeeringConnectionsRequest> marshall(DescribeVpcPeeringConnectionsRequest describeVpcPeeringConnectionsRequest) {
        if (describeVpcPeeringConnectionsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeVpcPeeringConnectionsRequest, "AmazonEC2");
        request.addParameter("Action", "DescribeVpcPeeringConnections");
        request.addParameter("Version", "2015-04-15");
        List<String> vpcPeeringConnectionIdsList = describeVpcPeeringConnectionsRequest.getVpcPeeringConnectionIds();
        int vpcPeeringConnectionIdsListIndex = 1;
        for (String vpcPeeringConnectionIdsListValue : vpcPeeringConnectionIdsList) {
            if (vpcPeeringConnectionIdsListValue != null) {
                request.addParameter("VpcPeeringConnectionId." + vpcPeeringConnectionIdsListIndex, StringUtils.fromString((String)vpcPeeringConnectionIdsListValue));
            }
            ++vpcPeeringConnectionIdsListIndex;
        }
        List<Filter> filtersList = describeVpcPeeringConnectionsRequest.getFilters();
        int filtersListIndex = 1;
        for (Filter filtersListValue : filtersList) {
            Filter filterMember = filtersListValue;
            if (filterMember != null) {
                if (filterMember.getName() != null) {
                    request.addParameter("Filter." + filtersListIndex + ".Name", StringUtils.fromString((String)filterMember.getName()));
                }
                List<String> valuesList = filterMember.getValues();
                int valuesListIndex = 1;
                for (String valuesListValue : valuesList) {
                    if (valuesListValue != null) {
                        request.addParameter("Filter." + filtersListIndex + ".Value." + valuesListIndex, StringUtils.fromString((String)valuesListValue));
                    }
                    ++valuesListIndex;
                }
            }
            ++filtersListIndex;
        }
        return request;
    }
}

