/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.document.internal;

import com.amazonaws.services.dynamodbv2.AmazonDynamoDB;
import com.amazonaws.services.dynamodbv2.document.BatchWriteItemOutcome;
import com.amazonaws.services.dynamodbv2.document.Item;
import com.amazonaws.services.dynamodbv2.document.PrimaryKey;
import com.amazonaws.services.dynamodbv2.document.TableWriteItems;
import com.amazonaws.services.dynamodbv2.document.api.BatchWriteItemApi;
import com.amazonaws.services.dynamodbv2.document.internal.InternalUtils;
import com.amazonaws.services.dynamodbv2.document.spec.BatchWriteItemSpec;
import com.amazonaws.services.dynamodbv2.model.BatchWriteItemRequest;
import com.amazonaws.services.dynamodbv2.model.BatchWriteItemResult;
import com.amazonaws.services.dynamodbv2.model.DeleteRequest;
import com.amazonaws.services.dynamodbv2.model.PutRequest;
import com.amazonaws.services.dynamodbv2.model.WriteRequest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class BatchWriteItemImpl
implements BatchWriteItemApi {
    private final AmazonDynamoDB client;

    public BatchWriteItemImpl(AmazonDynamoDB client) {
        this.client = client;
    }

    @Override
    public BatchWriteItemOutcome batchWriteItem(TableWriteItems ... tableWriteItems) {
        return this.doBatchWriteItem(new BatchWriteItemSpec().withTableWriteItems(tableWriteItems));
    }

    @Override
    public BatchWriteItemOutcome batchWriteItem(BatchWriteItemSpec spec) {
        return this.doBatchWriteItem(spec);
    }

    @Override
    public BatchWriteItemOutcome batchWriteItemUnprocessed(Map<String, List<WriteRequest>> unprocessedItems) {
        return this.doBatchWriteItem(new BatchWriteItemSpec().withUnprocessedItems(unprocessedItems));
    }

    private BatchWriteItemOutcome doBatchWriteItem(BatchWriteItemSpec spec) {
        Collection<TableWriteItems> tableWriteItemsCol = spec.getTableWriteItems();
        Map<String, List<WriteRequest>> requestItems = spec.getUnprocessedItems();
        if (requestItems == null || requestItems.size() == 0) {
            requestItems = new LinkedHashMap<String, List<WriteRequest>>(tableWriteItemsCol.size());
        }
        for (TableWriteItems tableWriteItems : tableWriteItemsCol) {
            Collection<Item> itemsToPut = tableWriteItems.getItemsToPut();
            List<PrimaryKey> pksToDelete = tableWriteItems.getPrimaryKeysToDelete();
            ArrayList<WriteRequest> writeRequests = new ArrayList<WriteRequest>(itemsToPut.size() + pksToDelete.size());
            for (Item item : itemsToPut) {
                writeRequests.add(new WriteRequest().withPutRequest(new PutRequest().withItem(InternalUtils.toAttributeValues(item))));
            }
            for (PrimaryKey pkToDelete : pksToDelete) {
                writeRequests.add(new WriteRequest().withDeleteRequest(new DeleteRequest().withKey(InternalUtils.toAttributeValueMap(pkToDelete))));
            }
            requestItems.put(tableWriteItems.getTableName(), writeRequests);
        }
        BatchWriteItemRequest req = ((BatchWriteItemRequest)spec.getRequest()).withRequestItems(requestItems).withReturnConsumedCapacity(spec.getReturnConsumedCapacity());
        BatchWriteItemResult result = this.client.batchWriteItem(req);
        return new BatchWriteItemOutcome(result);
    }
}

