/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.datamodeling;

import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDB;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBMapperFieldModel;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBMappingException;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBTypeConverted;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBTypeConverter;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBTyped;
import com.amazonaws.services.dynamodbv2.datamodeling.StandardBeanProperties;
import com.amazonaws.services.dynamodbv2.datamodeling.StandardTypeConverters;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.regex.Pattern;

@DynamoDB
@DynamoDBTypeConverted(converter=Converter.class)
@DynamoDBTyped(value=DynamoDBMapperFieldModel.DynamoDBAttributeType.S)
@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.TYPE, ElementType.FIELD, ElementType.METHOD, ElementType.ANNOTATION_TYPE})
public @interface DynamoDBDelimited {
    public char delimiter() default 124;

    public String[] attributeNames();

    public static final class Converter<T>
    implements DynamoDBTypeConverter<String, T> {
        private final Field<T, Object>[] fields;
        private final Class<T> targetType;
        private final String delimiter;

        public Converter(Class<T> targetType, DynamoDBDelimited annotation) {
            StandardBeanProperties.BeanMap beans = new StandardBeanProperties.BeanMap(targetType, true);
            String[] names = annotation.attributeNames();
            if (names.length <= 1) {
                throw new DynamoDBMappingException(targetType + " missing attributeNames in @DynamoDBDelimited; must specify two or more attribute names");
            }
            this.delimiter = String.valueOf(annotation.delimiter());
            this.fields = new Field[names.length];
            this.targetType = targetType;
            for (int i = 0; i < this.fields.length; ++i) {
                if (!beans.containsKey(names[i])) {
                    throw new DynamoDBMappingException(targetType + " does not map %s on model " + names[i]);
                }
                this.fields[i] = new Field(targetType, (StandardBeanProperties.Bean)beans.get(names[i]));
            }
        }

        @Override
        public final String convert(T object) {
            StringBuilder string = new StringBuilder();
            for (int i = 0; i < this.fields.length; ++i) {
                String value;
                if (i > 0) {
                    string.append(this.delimiter);
                }
                if ((value = ((Field)this.fields[i]).get(object)) == null) continue;
                if (value.contains(this.delimiter)) {
                    throw new DynamoDBMappingException(String.format("%s[%s] field value \"%s\" must not contain delimiter %s", this.targetType, ((Field)this.fields[i]).bean.properties().attributeName(), value, this.delimiter));
                }
                string.append(value);
            }
            return string.length() < this.fields.length ? null : string.toString();
        }

        @Override
        public final T unconvert(String string) {
            T object = StandardBeanProperties.DeclaringReflect.newInstance(this.targetType);
            String[] values = string.split(Pattern.quote(this.delimiter));
            int its = Math.min(this.fields.length, values.length);
            for (int i = 0; i < its; ++i) {
                ((Field)this.fields[i]).set(object, values[i]);
            }
            return object;
        }

        private static final class Field<T, V> {
            private final DynamoDBTypeConverter<String, V> converter;
            private final StandardBeanProperties.Bean<T, V> bean;

            private Field(Class<T> type, StandardBeanProperties.Bean<T, V> bean) {
                this.converter = bean.type().typeConverter() == null ? StandardTypeConverters.factory().getConverter(String.class, bean.type().targetType()) : bean.type().typeConverter();
                this.bean = bean;
            }

            private final String get(T object) {
                V value = this.bean.reflect().get(object);
                if (value == null) {
                    return null;
                }
                return this.converter.convert(value);
            }

            private final void set(T object, String string) {
                V value;
                if (!string.isEmpty() && (value = this.converter.unconvert(string)) != null) {
                    this.bean.reflect().set(object, value);
                }
            }
        }
    }
}

