/*
 * Copyright 2017-2022 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.dynamodbv2.model;

import java.io.Serializable;
import javax.annotation.Generated;

import com.amazonaws.AmazonWebServiceRequest;

/**
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/DescribeImport" target="_top">AWS API
 *      Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class DescribeImportRequest extends com.amazonaws.AmazonWebServiceRequest implements Serializable, Cloneable {

    /**
     * <p>
     * The Amazon Resource Name (ARN) associated with the table you're importing to.
     * </p>
     */
    private String importArn;

    /**
     * <p>
     * The Amazon Resource Name (ARN) associated with the table you're importing to.
     * </p>
     * 
     * @param importArn
     *        The Amazon Resource Name (ARN) associated with the table you're importing to.
     */

    public void setImportArn(String importArn) {
        this.importArn = importArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) associated with the table you're importing to.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) associated with the table you're importing to.
     */

    public String getImportArn() {
        return this.importArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) associated with the table you're importing to.
     * </p>
     * 
     * @param importArn
     *        The Amazon Resource Name (ARN) associated with the table you're importing to.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public DescribeImportRequest withImportArn(String importArn) {
        setImportArn(importArn);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getImportArn() != null)
            sb.append("ImportArn: ").append(getImportArn());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof DescribeImportRequest == false)
            return false;
        DescribeImportRequest other = (DescribeImportRequest) obj;
        if (other.getImportArn() == null ^ this.getImportArn() == null)
            return false;
        if (other.getImportArn() != null && other.getImportArn().equals(this.getImportArn()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getImportArn() == null) ? 0 : getImportArn().hashCode());
        return hashCode;
    }

    @Override
    public DescribeImportRequest clone() {
        return (DescribeImportRequest) super.clone();
    }

}
