/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.dynamodbv2.model.DeleteTableRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class DeleteTableRequestMarshaller
implements Marshaller<Request<DeleteTableRequest>, DeleteTableRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public DeleteTableRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<DeleteTableRequest> marshall(DeleteTableRequest deleteTableRequest) {
        if (deleteTableRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)deleteTableRequest, "AmazonDynamoDBv2");
        request.addHeader("X-Amz-Target", "DynamoDB_20120810.DeleteTable");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (deleteTableRequest.getTableName() != null) {
                jsonGenerator.writeFieldName("TableName").writeValue(deleteTableRequest.getTableName());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

