/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.dynamodbv2.model.StreamSpecification;
import com.amazonaws.util.json.StructuredJsonGenerator;

public class StreamSpecificationJsonMarshaller {
    private static StreamSpecificationJsonMarshaller instance;

    public void marshall(StreamSpecification streamSpecification, StructuredJsonGenerator jsonGenerator) {
        if (streamSpecification == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            if (streamSpecification.getStreamEnabled() != null) {
                jsonGenerator.writeFieldName("StreamEnabled").writeValue(streamSpecification.getStreamEnabled().booleanValue());
            }
            if (streamSpecification.getStreamViewType() != null) {
                jsonGenerator.writeFieldName("StreamViewType").writeValue(streamSpecification.getStreamViewType());
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static StreamSpecificationJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new StreamSpecificationJsonMarshaller();
        }
        return instance;
    }
}

