/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import com.amazonaws.services.dynamodbv2.model.ExpectedAttributeValue;
import com.amazonaws.services.dynamodbv2.model.PutItemRequest;
import com.amazonaws.services.dynamodbv2.model.transform.AttributeValueJsonMarshaller;
import com.amazonaws.services.dynamodbv2.model.transform.ExpectedAttributeValueJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.json.SdkJsonProtocolFactory;
import com.amazonaws.util.json.StructuredJsonGenerator;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Map;

public class PutItemRequestMarshaller
implements Marshaller<Request<PutItemRequest>, PutItemRequest> {
    public Request<PutItemRequest> marshall(PutItemRequest putItemRequest) {
        if (putItemRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)putItemRequest, "AmazonDynamoDBv2");
        request.addHeader("X-Amz-Target", "DynamoDB_20120810.PutItem");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            Map<String, AttributeValue> expressionAttributeValuesMap;
            Map<String, String> expressionAttributeNamesMap;
            Map<String, ExpectedAttributeValue> expectedMap;
            Map<String, AttributeValue> itemMap;
            StructuredJsonGenerator jsonGenerator = SdkJsonProtocolFactory.createWriter((boolean)false, (String)"1.0");
            jsonGenerator.writeStartObject();
            if (putItemRequest.getTableName() != null) {
                jsonGenerator.writeFieldName("TableName").writeValue(putItemRequest.getTableName());
            }
            if ((itemMap = putItemRequest.getItem()) != null) {
                jsonGenerator.writeFieldName("Item");
                jsonGenerator.writeStartObject();
                for (Map.Entry<String, AttributeValue> itemMapValue : itemMap.entrySet()) {
                    if (itemMapValue.getValue() == null) continue;
                    jsonGenerator.writeFieldName(itemMapValue.getKey());
                    AttributeValueJsonMarshaller.getInstance().marshall(itemMapValue.getValue(), jsonGenerator);
                }
                jsonGenerator.writeEndObject();
            }
            if ((expectedMap = putItemRequest.getExpected()) != null) {
                jsonGenerator.writeFieldName("Expected");
                jsonGenerator.writeStartObject();
                for (Map.Entry<String, ExpectedAttributeValue> expectedMapValue : expectedMap.entrySet()) {
                    if (expectedMapValue.getValue() == null) continue;
                    jsonGenerator.writeFieldName(expectedMapValue.getKey());
                    ExpectedAttributeValueJsonMarshaller.getInstance().marshall(expectedMapValue.getValue(), jsonGenerator);
                }
                jsonGenerator.writeEndObject();
            }
            if (putItemRequest.getReturnValues() != null) {
                jsonGenerator.writeFieldName("ReturnValues").writeValue(putItemRequest.getReturnValues());
            }
            if (putItemRequest.getReturnConsumedCapacity() != null) {
                jsonGenerator.writeFieldName("ReturnConsumedCapacity").writeValue(putItemRequest.getReturnConsumedCapacity());
            }
            if (putItemRequest.getReturnItemCollectionMetrics() != null) {
                jsonGenerator.writeFieldName("ReturnItemCollectionMetrics").writeValue(putItemRequest.getReturnItemCollectionMetrics());
            }
            if (putItemRequest.getConditionalOperator() != null) {
                jsonGenerator.writeFieldName("ConditionalOperator").writeValue(putItemRequest.getConditionalOperator());
            }
            if (putItemRequest.getConditionExpression() != null) {
                jsonGenerator.writeFieldName("ConditionExpression").writeValue(putItemRequest.getConditionExpression());
            }
            if ((expressionAttributeNamesMap = putItemRequest.getExpressionAttributeNames()) != null) {
                jsonGenerator.writeFieldName("ExpressionAttributeNames");
                jsonGenerator.writeStartObject();
                for (Map.Entry<String, String> expressionAttributeNamesMapValue : expressionAttributeNamesMap.entrySet()) {
                    if (expressionAttributeNamesMapValue.getValue() == null) continue;
                    jsonGenerator.writeFieldName(expressionAttributeNamesMapValue.getKey());
                    jsonGenerator.writeValue(expressionAttributeNamesMapValue.getValue());
                }
                jsonGenerator.writeEndObject();
            }
            if ((expressionAttributeValuesMap = putItemRequest.getExpressionAttributeValues()) != null) {
                jsonGenerator.writeFieldName("ExpressionAttributeValues");
                jsonGenerator.writeStartObject();
                for (Map.Entry<String, AttributeValue> expressionAttributeValuesMapValue : expressionAttributeValuesMap.entrySet()) {
                    if (expressionAttributeValuesMapValue.getValue() == null) continue;
                    jsonGenerator.writeFieldName(expressionAttributeValuesMapValue.getKey());
                    AttributeValueJsonMarshaller.getInstance().marshall(expressionAttributeValuesMapValue.getValue(), jsonGenerator);
                }
                jsonGenerator.writeEndObject();
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", jsonGenerator.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

