/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.drs.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.drs.model.LaunchActionRun;
import com.amazonaws.services.drs.model.transform.LaunchActionsStatusMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class LaunchActionsStatus
implements Serializable,
Cloneable,
StructuredPojo {
    private List<LaunchActionRun> runs;
    private String ssmAgentDiscoveryDatetime;

    public List<LaunchActionRun> getRuns() {
        return this.runs;
    }

    public void setRuns(Collection<LaunchActionRun> runs) {
        if (runs == null) {
            this.runs = null;
            return;
        }
        this.runs = new ArrayList<LaunchActionRun>(runs);
    }

    public LaunchActionsStatus withRuns(LaunchActionRun ... runs) {
        if (this.runs == null) {
            this.setRuns(new ArrayList<LaunchActionRun>(runs.length));
        }
        for (LaunchActionRun ele : runs) {
            this.runs.add(ele);
        }
        return this;
    }

    public LaunchActionsStatus withRuns(Collection<LaunchActionRun> runs) {
        this.setRuns(runs);
        return this;
    }

    public void setSsmAgentDiscoveryDatetime(String ssmAgentDiscoveryDatetime) {
        this.ssmAgentDiscoveryDatetime = ssmAgentDiscoveryDatetime;
    }

    public String getSsmAgentDiscoveryDatetime() {
        return this.ssmAgentDiscoveryDatetime;
    }

    public LaunchActionsStatus withSsmAgentDiscoveryDatetime(String ssmAgentDiscoveryDatetime) {
        this.setSsmAgentDiscoveryDatetime(ssmAgentDiscoveryDatetime);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getRuns() != null) {
            sb.append("Runs: ").append(this.getRuns()).append(",");
        }
        if (this.getSsmAgentDiscoveryDatetime() != null) {
            sb.append("SsmAgentDiscoveryDatetime: ").append(this.getSsmAgentDiscoveryDatetime());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LaunchActionsStatus)) {
            return false;
        }
        LaunchActionsStatus other = (LaunchActionsStatus)obj;
        if (other.getRuns() == null ^ this.getRuns() == null) {
            return false;
        }
        if (other.getRuns() != null && !other.getRuns().equals(this.getRuns())) {
            return false;
        }
        if (other.getSsmAgentDiscoveryDatetime() == null ^ this.getSsmAgentDiscoveryDatetime() == null) {
            return false;
        }
        return other.getSsmAgentDiscoveryDatetime() == null || other.getSsmAgentDiscoveryDatetime().equals(this.getSsmAgentDiscoveryDatetime());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getRuns() == null ? 0 : this.getRuns().hashCode());
        hashCode = 31 * hashCode + (this.getSsmAgentDiscoveryDatetime() == null ? 0 : this.getSsmAgentDiscoveryDatetime().hashCode());
        return hashCode;
    }

    public LaunchActionsStatus clone() {
        try {
            return (LaunchActionsStatus)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        LaunchActionsStatusMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

