/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.databasemigrationservice.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.databasemigrationservice.model.InstanceProfile;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class DescribeInstanceProfilesResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private String marker;
    private List<InstanceProfile> instanceProfiles;

    public void setMarker(String marker) {
        this.marker = marker;
    }

    public String getMarker() {
        return this.marker;
    }

    public DescribeInstanceProfilesResult withMarker(String marker) {
        this.setMarker(marker);
        return this;
    }

    public List<InstanceProfile> getInstanceProfiles() {
        return this.instanceProfiles;
    }

    public void setInstanceProfiles(Collection<InstanceProfile> instanceProfiles) {
        if (instanceProfiles == null) {
            this.instanceProfiles = null;
            return;
        }
        this.instanceProfiles = new ArrayList<InstanceProfile>(instanceProfiles);
    }

    public DescribeInstanceProfilesResult withInstanceProfiles(InstanceProfile ... instanceProfiles) {
        if (this.instanceProfiles == null) {
            this.setInstanceProfiles(new ArrayList<InstanceProfile>(instanceProfiles.length));
        }
        for (InstanceProfile ele : instanceProfiles) {
            this.instanceProfiles.add(ele);
        }
        return this;
    }

    public DescribeInstanceProfilesResult withInstanceProfiles(Collection<InstanceProfile> instanceProfiles) {
        this.setInstanceProfiles(instanceProfiles);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getMarker() != null) {
            sb.append("Marker: ").append(this.getMarker()).append(",");
        }
        if (this.getInstanceProfiles() != null) {
            sb.append("InstanceProfiles: ").append(this.getInstanceProfiles());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeInstanceProfilesResult)) {
            return false;
        }
        DescribeInstanceProfilesResult other = (DescribeInstanceProfilesResult)obj;
        if (other.getMarker() == null ^ this.getMarker() == null) {
            return false;
        }
        if (other.getMarker() != null && !other.getMarker().equals(this.getMarker())) {
            return false;
        }
        if (other.getInstanceProfiles() == null ^ this.getInstanceProfiles() == null) {
            return false;
        }
        return other.getInstanceProfiles() == null || other.getInstanceProfiles().equals(this.getInstanceProfiles());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getMarker() == null ? 0 : this.getMarker().hashCode());
        hashCode = 31 * hashCode + (this.getInstanceProfiles() == null ? 0 : this.getInstanceProfiles().hashCode());
        return hashCode;
    }

    public DescribeInstanceProfilesResult clone() {
        try {
            return (DescribeInstanceProfilesResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

