/*
 * Copyright 2019-2024 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.databasemigrationservice.model;

import java.io.Serializable;
import javax.annotation.Generated;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.protocol.ProtocolMarshaller;

/**
 * <p>
 * Provides information about the source database to analyze and provide target recommendations according to the
 * specified requirements.
 * </p>
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/StartRecommendationsRequestEntry"
 *      target="_top">AWS API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class StartRecommendationsRequestEntry implements Serializable, Cloneable, StructuredPojo {

    /**
     * <p>
     * The identifier of the source database.
     * </p>
     */
    private String databaseId;
    /**
     * <p>
     * The required target engine settings.
     * </p>
     */
    private RecommendationSettings settings;

    /**
     * <p>
     * The identifier of the source database.
     * </p>
     * 
     * @param databaseId
     *        The identifier of the source database.
     */

    public void setDatabaseId(String databaseId) {
        this.databaseId = databaseId;
    }

    /**
     * <p>
     * The identifier of the source database.
     * </p>
     * 
     * @return The identifier of the source database.
     */

    public String getDatabaseId() {
        return this.databaseId;
    }

    /**
     * <p>
     * The identifier of the source database.
     * </p>
     * 
     * @param databaseId
     *        The identifier of the source database.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public StartRecommendationsRequestEntry withDatabaseId(String databaseId) {
        setDatabaseId(databaseId);
        return this;
    }

    /**
     * <p>
     * The required target engine settings.
     * </p>
     * 
     * @param settings
     *        The required target engine settings.
     */

    public void setSettings(RecommendationSettings settings) {
        this.settings = settings;
    }

    /**
     * <p>
     * The required target engine settings.
     * </p>
     * 
     * @return The required target engine settings.
     */

    public RecommendationSettings getSettings() {
        return this.settings;
    }

    /**
     * <p>
     * The required target engine settings.
     * </p>
     * 
     * @param settings
     *        The required target engine settings.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public StartRecommendationsRequestEntry withSettings(RecommendationSettings settings) {
        setSettings(settings);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getDatabaseId() != null)
            sb.append("DatabaseId: ").append(getDatabaseId()).append(",");
        if (getSettings() != null)
            sb.append("Settings: ").append(getSettings());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof StartRecommendationsRequestEntry == false)
            return false;
        StartRecommendationsRequestEntry other = (StartRecommendationsRequestEntry) obj;
        if (other.getDatabaseId() == null ^ this.getDatabaseId() == null)
            return false;
        if (other.getDatabaseId() != null && other.getDatabaseId().equals(this.getDatabaseId()) == false)
            return false;
        if (other.getSettings() == null ^ this.getSettings() == null)
            return false;
        if (other.getSettings() != null && other.getSettings().equals(this.getSettings()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getDatabaseId() == null) ? 0 : getDatabaseId().hashCode());
        hashCode = prime * hashCode + ((getSettings() == null) ? 0 : getSettings().hashCode());
        return hashCode;
    }

    @Override
    public StartRecommendationsRequestEntry clone() {
        try {
            return (StartRecommendationsRequestEntry) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

    @com.amazonaws.annotation.SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        com.amazonaws.services.databasemigrationservice.model.transform.StartRecommendationsRequestEntryMarshaller.getInstance().marshall(this,
                protocolMarshaller);
    }
}
