/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.databasemigrationservice.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.databasemigrationservice.model.ReleaseStatusValues;
import com.amazonaws.services.databasemigrationservice.model.transform.EngineVersionMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class EngineVersion
implements Serializable,
Cloneable,
StructuredPojo {
    private String version;
    private String lifecycle;
    private String releaseStatus;
    private Date launchDate;
    private Date autoUpgradeDate;
    private Date deprecationDate;
    private Date forceUpgradeDate;
    private List<String> availableUpgrades;

    public void setVersion(String version) {
        this.version = version;
    }

    public String getVersion() {
        return this.version;
    }

    public EngineVersion withVersion(String version) {
        this.setVersion(version);
        return this;
    }

    public void setLifecycle(String lifecycle) {
        this.lifecycle = lifecycle;
    }

    public String getLifecycle() {
        return this.lifecycle;
    }

    public EngineVersion withLifecycle(String lifecycle) {
        this.setLifecycle(lifecycle);
        return this;
    }

    public void setReleaseStatus(String releaseStatus) {
        this.releaseStatus = releaseStatus;
    }

    public String getReleaseStatus() {
        return this.releaseStatus;
    }

    public EngineVersion withReleaseStatus(String releaseStatus) {
        this.setReleaseStatus(releaseStatus);
        return this;
    }

    public EngineVersion withReleaseStatus(ReleaseStatusValues releaseStatus) {
        this.releaseStatus = releaseStatus.toString();
        return this;
    }

    public void setLaunchDate(Date launchDate) {
        this.launchDate = launchDate;
    }

    public Date getLaunchDate() {
        return this.launchDate;
    }

    public EngineVersion withLaunchDate(Date launchDate) {
        this.setLaunchDate(launchDate);
        return this;
    }

    public void setAutoUpgradeDate(Date autoUpgradeDate) {
        this.autoUpgradeDate = autoUpgradeDate;
    }

    public Date getAutoUpgradeDate() {
        return this.autoUpgradeDate;
    }

    public EngineVersion withAutoUpgradeDate(Date autoUpgradeDate) {
        this.setAutoUpgradeDate(autoUpgradeDate);
        return this;
    }

    public void setDeprecationDate(Date deprecationDate) {
        this.deprecationDate = deprecationDate;
    }

    public Date getDeprecationDate() {
        return this.deprecationDate;
    }

    public EngineVersion withDeprecationDate(Date deprecationDate) {
        this.setDeprecationDate(deprecationDate);
        return this;
    }

    public void setForceUpgradeDate(Date forceUpgradeDate) {
        this.forceUpgradeDate = forceUpgradeDate;
    }

    public Date getForceUpgradeDate() {
        return this.forceUpgradeDate;
    }

    public EngineVersion withForceUpgradeDate(Date forceUpgradeDate) {
        this.setForceUpgradeDate(forceUpgradeDate);
        return this;
    }

    public List<String> getAvailableUpgrades() {
        return this.availableUpgrades;
    }

    public void setAvailableUpgrades(Collection<String> availableUpgrades) {
        if (availableUpgrades == null) {
            this.availableUpgrades = null;
            return;
        }
        this.availableUpgrades = new ArrayList<String>(availableUpgrades);
    }

    public EngineVersion withAvailableUpgrades(String ... availableUpgrades) {
        if (this.availableUpgrades == null) {
            this.setAvailableUpgrades(new ArrayList<String>(availableUpgrades.length));
        }
        for (String ele : availableUpgrades) {
            this.availableUpgrades.add(ele);
        }
        return this;
    }

    public EngineVersion withAvailableUpgrades(Collection<String> availableUpgrades) {
        this.setAvailableUpgrades(availableUpgrades);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getVersion() != null) {
            sb.append("Version: ").append(this.getVersion()).append(",");
        }
        if (this.getLifecycle() != null) {
            sb.append("Lifecycle: ").append(this.getLifecycle()).append(",");
        }
        if (this.getReleaseStatus() != null) {
            sb.append("ReleaseStatus: ").append(this.getReleaseStatus()).append(",");
        }
        if (this.getLaunchDate() != null) {
            sb.append("LaunchDate: ").append(this.getLaunchDate()).append(",");
        }
        if (this.getAutoUpgradeDate() != null) {
            sb.append("AutoUpgradeDate: ").append(this.getAutoUpgradeDate()).append(",");
        }
        if (this.getDeprecationDate() != null) {
            sb.append("DeprecationDate: ").append(this.getDeprecationDate()).append(",");
        }
        if (this.getForceUpgradeDate() != null) {
            sb.append("ForceUpgradeDate: ").append(this.getForceUpgradeDate()).append(",");
        }
        if (this.getAvailableUpgrades() != null) {
            sb.append("AvailableUpgrades: ").append(this.getAvailableUpgrades());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EngineVersion)) {
            return false;
        }
        EngineVersion other = (EngineVersion)obj;
        if (other.getVersion() == null ^ this.getVersion() == null) {
            return false;
        }
        if (other.getVersion() != null && !other.getVersion().equals(this.getVersion())) {
            return false;
        }
        if (other.getLifecycle() == null ^ this.getLifecycle() == null) {
            return false;
        }
        if (other.getLifecycle() != null && !other.getLifecycle().equals(this.getLifecycle())) {
            return false;
        }
        if (other.getReleaseStatus() == null ^ this.getReleaseStatus() == null) {
            return false;
        }
        if (other.getReleaseStatus() != null && !other.getReleaseStatus().equals(this.getReleaseStatus())) {
            return false;
        }
        if (other.getLaunchDate() == null ^ this.getLaunchDate() == null) {
            return false;
        }
        if (other.getLaunchDate() != null && !other.getLaunchDate().equals(this.getLaunchDate())) {
            return false;
        }
        if (other.getAutoUpgradeDate() == null ^ this.getAutoUpgradeDate() == null) {
            return false;
        }
        if (other.getAutoUpgradeDate() != null && !other.getAutoUpgradeDate().equals(this.getAutoUpgradeDate())) {
            return false;
        }
        if (other.getDeprecationDate() == null ^ this.getDeprecationDate() == null) {
            return false;
        }
        if (other.getDeprecationDate() != null && !other.getDeprecationDate().equals(this.getDeprecationDate())) {
            return false;
        }
        if (other.getForceUpgradeDate() == null ^ this.getForceUpgradeDate() == null) {
            return false;
        }
        if (other.getForceUpgradeDate() != null && !other.getForceUpgradeDate().equals(this.getForceUpgradeDate())) {
            return false;
        }
        if (other.getAvailableUpgrades() == null ^ this.getAvailableUpgrades() == null) {
            return false;
        }
        return other.getAvailableUpgrades() == null || other.getAvailableUpgrades().equals(this.getAvailableUpgrades());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getVersion() == null ? 0 : this.getVersion().hashCode());
        hashCode = 31 * hashCode + (this.getLifecycle() == null ? 0 : this.getLifecycle().hashCode());
        hashCode = 31 * hashCode + (this.getReleaseStatus() == null ? 0 : this.getReleaseStatus().hashCode());
        hashCode = 31 * hashCode + (this.getLaunchDate() == null ? 0 : this.getLaunchDate().hashCode());
        hashCode = 31 * hashCode + (this.getAutoUpgradeDate() == null ? 0 : this.getAutoUpgradeDate().hashCode());
        hashCode = 31 * hashCode + (this.getDeprecationDate() == null ? 0 : this.getDeprecationDate().hashCode());
        hashCode = 31 * hashCode + (this.getForceUpgradeDate() == null ? 0 : this.getForceUpgradeDate().hashCode());
        hashCode = 31 * hashCode + (this.getAvailableUpgrades() == null ? 0 : this.getAvailableUpgrades().hashCode());
        return hashCode;
    }

    public EngineVersion clone() {
        try {
            return (EngineVersion)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        EngineVersionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

