/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.databasemigrationservice.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.databasemigrationservice.model.EndpointSettingTypeValue;
import com.amazonaws.services.databasemigrationservice.model.transform.EndpointSettingMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class EndpointSetting
implements Serializable,
Cloneable,
StructuredPojo {
    private String name;
    private String type;
    private List<String> enumValues;
    private Boolean sensitive;
    private String units;
    private String applicability;
    private Integer intValueMin;
    private Integer intValueMax;
    private String defaultValue;

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public EndpointSetting withName(String name) {
        this.setName(name);
        return this;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public EndpointSetting withType(String type) {
        this.setType(type);
        return this;
    }

    public EndpointSetting withType(EndpointSettingTypeValue type) {
        this.type = type.toString();
        return this;
    }

    public List<String> getEnumValues() {
        return this.enumValues;
    }

    public void setEnumValues(Collection<String> enumValues) {
        if (enumValues == null) {
            this.enumValues = null;
            return;
        }
        this.enumValues = new ArrayList<String>(enumValues);
    }

    public EndpointSetting withEnumValues(String ... enumValues) {
        if (this.enumValues == null) {
            this.setEnumValues(new ArrayList<String>(enumValues.length));
        }
        for (String ele : enumValues) {
            this.enumValues.add(ele);
        }
        return this;
    }

    public EndpointSetting withEnumValues(Collection<String> enumValues) {
        this.setEnumValues(enumValues);
        return this;
    }

    public void setSensitive(Boolean sensitive) {
        this.sensitive = sensitive;
    }

    public Boolean getSensitive() {
        return this.sensitive;
    }

    public EndpointSetting withSensitive(Boolean sensitive) {
        this.setSensitive(sensitive);
        return this;
    }

    public Boolean isSensitive() {
        return this.sensitive;
    }

    public void setUnits(String units) {
        this.units = units;
    }

    public String getUnits() {
        return this.units;
    }

    public EndpointSetting withUnits(String units) {
        this.setUnits(units);
        return this;
    }

    public void setApplicability(String applicability) {
        this.applicability = applicability;
    }

    public String getApplicability() {
        return this.applicability;
    }

    public EndpointSetting withApplicability(String applicability) {
        this.setApplicability(applicability);
        return this;
    }

    public void setIntValueMin(Integer intValueMin) {
        this.intValueMin = intValueMin;
    }

    public Integer getIntValueMin() {
        return this.intValueMin;
    }

    public EndpointSetting withIntValueMin(Integer intValueMin) {
        this.setIntValueMin(intValueMin);
        return this;
    }

    public void setIntValueMax(Integer intValueMax) {
        this.intValueMax = intValueMax;
    }

    public Integer getIntValueMax() {
        return this.intValueMax;
    }

    public EndpointSetting withIntValueMax(Integer intValueMax) {
        this.setIntValueMax(intValueMax);
        return this;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public EndpointSetting withDefaultValue(String defaultValue) {
        this.setDefaultValue(defaultValue);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getType() != null) {
            sb.append("Type: ").append(this.getType()).append(",");
        }
        if (this.getEnumValues() != null) {
            sb.append("EnumValues: ").append(this.getEnumValues()).append(",");
        }
        if (this.getSensitive() != null) {
            sb.append("Sensitive: ").append(this.getSensitive()).append(",");
        }
        if (this.getUnits() != null) {
            sb.append("Units: ").append(this.getUnits()).append(",");
        }
        if (this.getApplicability() != null) {
            sb.append("Applicability: ").append(this.getApplicability()).append(",");
        }
        if (this.getIntValueMin() != null) {
            sb.append("IntValueMin: ").append(this.getIntValueMin()).append(",");
        }
        if (this.getIntValueMax() != null) {
            sb.append("IntValueMax: ").append(this.getIntValueMax()).append(",");
        }
        if (this.getDefaultValue() != null) {
            sb.append("DefaultValue: ").append(this.getDefaultValue());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EndpointSetting)) {
            return false;
        }
        EndpointSetting other = (EndpointSetting)obj;
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getType() == null ^ this.getType() == null) {
            return false;
        }
        if (other.getType() != null && !other.getType().equals(this.getType())) {
            return false;
        }
        if (other.getEnumValues() == null ^ this.getEnumValues() == null) {
            return false;
        }
        if (other.getEnumValues() != null && !other.getEnumValues().equals(this.getEnumValues())) {
            return false;
        }
        if (other.getSensitive() == null ^ this.getSensitive() == null) {
            return false;
        }
        if (other.getSensitive() != null && !other.getSensitive().equals(this.getSensitive())) {
            return false;
        }
        if (other.getUnits() == null ^ this.getUnits() == null) {
            return false;
        }
        if (other.getUnits() != null && !other.getUnits().equals(this.getUnits())) {
            return false;
        }
        if (other.getApplicability() == null ^ this.getApplicability() == null) {
            return false;
        }
        if (other.getApplicability() != null && !other.getApplicability().equals(this.getApplicability())) {
            return false;
        }
        if (other.getIntValueMin() == null ^ this.getIntValueMin() == null) {
            return false;
        }
        if (other.getIntValueMin() != null && !other.getIntValueMin().equals(this.getIntValueMin())) {
            return false;
        }
        if (other.getIntValueMax() == null ^ this.getIntValueMax() == null) {
            return false;
        }
        if (other.getIntValueMax() != null && !other.getIntValueMax().equals(this.getIntValueMax())) {
            return false;
        }
        if (other.getDefaultValue() == null ^ this.getDefaultValue() == null) {
            return false;
        }
        return other.getDefaultValue() == null || other.getDefaultValue().equals(this.getDefaultValue());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getType() == null ? 0 : this.getType().hashCode());
        hashCode = 31 * hashCode + (this.getEnumValues() == null ? 0 : this.getEnumValues().hashCode());
        hashCode = 31 * hashCode + (this.getSensitive() == null ? 0 : this.getSensitive().hashCode());
        hashCode = 31 * hashCode + (this.getUnits() == null ? 0 : this.getUnits().hashCode());
        hashCode = 31 * hashCode + (this.getApplicability() == null ? 0 : this.getApplicability().hashCode());
        hashCode = 31 * hashCode + (this.getIntValueMin() == null ? 0 : this.getIntValueMin().hashCode());
        hashCode = 31 * hashCode + (this.getIntValueMax() == null ? 0 : this.getIntValueMax().hashCode());
        hashCode = 31 * hashCode + (this.getDefaultValue() == null ? 0 : this.getDefaultValue().hashCode());
        return hashCode;
    }

    public EndpointSetting clone() {
        try {
            return (EndpointSetting)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        EndpointSettingMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

