/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dlm.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.dlm.model.Action;
import com.amazonaws.services.dlm.model.CrossRegionCopyTarget;
import com.amazonaws.services.dlm.model.EventSource;
import com.amazonaws.services.dlm.model.Exclusions;
import com.amazonaws.services.dlm.model.Parameters;
import com.amazonaws.services.dlm.model.PolicyLanguageValues;
import com.amazonaws.services.dlm.model.PolicyTypeValues;
import com.amazonaws.services.dlm.model.ResourceLocationValues;
import com.amazonaws.services.dlm.model.ResourceTypeValues;
import com.amazonaws.services.dlm.model.Schedule;
import com.amazonaws.services.dlm.model.Tag;
import com.amazonaws.services.dlm.model.transform.PolicyDetailsMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class PolicyDetails
implements Serializable,
Cloneable,
StructuredPojo {
    private String policyType;
    private List<String> resourceTypes;
    private List<String> resourceLocations;
    private List<Tag> targetTags;
    private List<Schedule> schedules;
    private Parameters parameters;
    private EventSource eventSource;
    private List<Action> actions;
    private String policyLanguage;
    private String resourceType;
    private Integer createInterval;
    private Integer retainInterval;
    private Boolean copyTags;
    private List<CrossRegionCopyTarget> crossRegionCopyTargets;
    private Boolean extendDeletion;
    private Exclusions exclusions;

    public void setPolicyType(String policyType) {
        this.policyType = policyType;
    }

    public String getPolicyType() {
        return this.policyType;
    }

    public PolicyDetails withPolicyType(String policyType) {
        this.setPolicyType(policyType);
        return this;
    }

    public PolicyDetails withPolicyType(PolicyTypeValues policyType) {
        this.policyType = policyType.toString();
        return this;
    }

    public List<String> getResourceTypes() {
        return this.resourceTypes;
    }

    public void setResourceTypes(Collection<String> resourceTypes) {
        if (resourceTypes == null) {
            this.resourceTypes = null;
            return;
        }
        this.resourceTypes = new ArrayList<String>(resourceTypes);
    }

    public PolicyDetails withResourceTypes(String ... resourceTypes) {
        if (this.resourceTypes == null) {
            this.setResourceTypes(new ArrayList<String>(resourceTypes.length));
        }
        for (String ele : resourceTypes) {
            this.resourceTypes.add(ele);
        }
        return this;
    }

    public PolicyDetails withResourceTypes(Collection<String> resourceTypes) {
        this.setResourceTypes(resourceTypes);
        return this;
    }

    public PolicyDetails withResourceTypes(ResourceTypeValues ... resourceTypes) {
        ArrayList<String> resourceTypesCopy = new ArrayList<String>(resourceTypes.length);
        for (ResourceTypeValues value : resourceTypes) {
            resourceTypesCopy.add(value.toString());
        }
        if (this.getResourceTypes() == null) {
            this.setResourceTypes(resourceTypesCopy);
        } else {
            this.getResourceTypes().addAll(resourceTypesCopy);
        }
        return this;
    }

    public List<String> getResourceLocations() {
        return this.resourceLocations;
    }

    public void setResourceLocations(Collection<String> resourceLocations) {
        if (resourceLocations == null) {
            this.resourceLocations = null;
            return;
        }
        this.resourceLocations = new ArrayList<String>(resourceLocations);
    }

    public PolicyDetails withResourceLocations(String ... resourceLocations) {
        if (this.resourceLocations == null) {
            this.setResourceLocations(new ArrayList<String>(resourceLocations.length));
        }
        for (String ele : resourceLocations) {
            this.resourceLocations.add(ele);
        }
        return this;
    }

    public PolicyDetails withResourceLocations(Collection<String> resourceLocations) {
        this.setResourceLocations(resourceLocations);
        return this;
    }

    public PolicyDetails withResourceLocations(ResourceLocationValues ... resourceLocations) {
        ArrayList<String> resourceLocationsCopy = new ArrayList<String>(resourceLocations.length);
        for (ResourceLocationValues value : resourceLocations) {
            resourceLocationsCopy.add(value.toString());
        }
        if (this.getResourceLocations() == null) {
            this.setResourceLocations(resourceLocationsCopy);
        } else {
            this.getResourceLocations().addAll(resourceLocationsCopy);
        }
        return this;
    }

    public List<Tag> getTargetTags() {
        return this.targetTags;
    }

    public void setTargetTags(Collection<Tag> targetTags) {
        if (targetTags == null) {
            this.targetTags = null;
            return;
        }
        this.targetTags = new ArrayList<Tag>(targetTags);
    }

    public PolicyDetails withTargetTags(Tag ... targetTags) {
        if (this.targetTags == null) {
            this.setTargetTags(new ArrayList<Tag>(targetTags.length));
        }
        for (Tag ele : targetTags) {
            this.targetTags.add(ele);
        }
        return this;
    }

    public PolicyDetails withTargetTags(Collection<Tag> targetTags) {
        this.setTargetTags(targetTags);
        return this;
    }

    public List<Schedule> getSchedules() {
        return this.schedules;
    }

    public void setSchedules(Collection<Schedule> schedules) {
        if (schedules == null) {
            this.schedules = null;
            return;
        }
        this.schedules = new ArrayList<Schedule>(schedules);
    }

    public PolicyDetails withSchedules(Schedule ... schedules) {
        if (this.schedules == null) {
            this.setSchedules(new ArrayList<Schedule>(schedules.length));
        }
        for (Schedule ele : schedules) {
            this.schedules.add(ele);
        }
        return this;
    }

    public PolicyDetails withSchedules(Collection<Schedule> schedules) {
        this.setSchedules(schedules);
        return this;
    }

    public void setParameters(Parameters parameters) {
        this.parameters = parameters;
    }

    public Parameters getParameters() {
        return this.parameters;
    }

    public PolicyDetails withParameters(Parameters parameters) {
        this.setParameters(parameters);
        return this;
    }

    public void setEventSource(EventSource eventSource) {
        this.eventSource = eventSource;
    }

    public EventSource getEventSource() {
        return this.eventSource;
    }

    public PolicyDetails withEventSource(EventSource eventSource) {
        this.setEventSource(eventSource);
        return this;
    }

    public List<Action> getActions() {
        return this.actions;
    }

    public void setActions(Collection<Action> actions) {
        if (actions == null) {
            this.actions = null;
            return;
        }
        this.actions = new ArrayList<Action>(actions);
    }

    public PolicyDetails withActions(Action ... actions) {
        if (this.actions == null) {
            this.setActions(new ArrayList<Action>(actions.length));
        }
        for (Action ele : actions) {
            this.actions.add(ele);
        }
        return this;
    }

    public PolicyDetails withActions(Collection<Action> actions) {
        this.setActions(actions);
        return this;
    }

    public void setPolicyLanguage(String policyLanguage) {
        this.policyLanguage = policyLanguage;
    }

    public String getPolicyLanguage() {
        return this.policyLanguage;
    }

    public PolicyDetails withPolicyLanguage(String policyLanguage) {
        this.setPolicyLanguage(policyLanguage);
        return this;
    }

    public PolicyDetails withPolicyLanguage(PolicyLanguageValues policyLanguage) {
        this.policyLanguage = policyLanguage.toString();
        return this;
    }

    public void setResourceType(String resourceType) {
        this.resourceType = resourceType;
    }

    public String getResourceType() {
        return this.resourceType;
    }

    public PolicyDetails withResourceType(String resourceType) {
        this.setResourceType(resourceType);
        return this;
    }

    public PolicyDetails withResourceType(ResourceTypeValues resourceType) {
        this.resourceType = resourceType.toString();
        return this;
    }

    public void setCreateInterval(Integer createInterval) {
        this.createInterval = createInterval;
    }

    public Integer getCreateInterval() {
        return this.createInterval;
    }

    public PolicyDetails withCreateInterval(Integer createInterval) {
        this.setCreateInterval(createInterval);
        return this;
    }

    public void setRetainInterval(Integer retainInterval) {
        this.retainInterval = retainInterval;
    }

    public Integer getRetainInterval() {
        return this.retainInterval;
    }

    public PolicyDetails withRetainInterval(Integer retainInterval) {
        this.setRetainInterval(retainInterval);
        return this;
    }

    public void setCopyTags(Boolean copyTags) {
        this.copyTags = copyTags;
    }

    public Boolean getCopyTags() {
        return this.copyTags;
    }

    public PolicyDetails withCopyTags(Boolean copyTags) {
        this.setCopyTags(copyTags);
        return this;
    }

    public Boolean isCopyTags() {
        return this.copyTags;
    }

    public List<CrossRegionCopyTarget> getCrossRegionCopyTargets() {
        return this.crossRegionCopyTargets;
    }

    public void setCrossRegionCopyTargets(Collection<CrossRegionCopyTarget> crossRegionCopyTargets) {
        if (crossRegionCopyTargets == null) {
            this.crossRegionCopyTargets = null;
            return;
        }
        this.crossRegionCopyTargets = new ArrayList<CrossRegionCopyTarget>(crossRegionCopyTargets);
    }

    public PolicyDetails withCrossRegionCopyTargets(CrossRegionCopyTarget ... crossRegionCopyTargets) {
        if (this.crossRegionCopyTargets == null) {
            this.setCrossRegionCopyTargets(new ArrayList<CrossRegionCopyTarget>(crossRegionCopyTargets.length));
        }
        for (CrossRegionCopyTarget ele : crossRegionCopyTargets) {
            this.crossRegionCopyTargets.add(ele);
        }
        return this;
    }

    public PolicyDetails withCrossRegionCopyTargets(Collection<CrossRegionCopyTarget> crossRegionCopyTargets) {
        this.setCrossRegionCopyTargets(crossRegionCopyTargets);
        return this;
    }

    public void setExtendDeletion(Boolean extendDeletion) {
        this.extendDeletion = extendDeletion;
    }

    public Boolean getExtendDeletion() {
        return this.extendDeletion;
    }

    public PolicyDetails withExtendDeletion(Boolean extendDeletion) {
        this.setExtendDeletion(extendDeletion);
        return this;
    }

    public Boolean isExtendDeletion() {
        return this.extendDeletion;
    }

    public void setExclusions(Exclusions exclusions) {
        this.exclusions = exclusions;
    }

    public Exclusions getExclusions() {
        return this.exclusions;
    }

    public PolicyDetails withExclusions(Exclusions exclusions) {
        this.setExclusions(exclusions);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getPolicyType() != null) {
            sb.append("PolicyType: ").append(this.getPolicyType()).append(",");
        }
        if (this.getResourceTypes() != null) {
            sb.append("ResourceTypes: ").append(this.getResourceTypes()).append(",");
        }
        if (this.getResourceLocations() != null) {
            sb.append("ResourceLocations: ").append(this.getResourceLocations()).append(",");
        }
        if (this.getTargetTags() != null) {
            sb.append("TargetTags: ").append(this.getTargetTags()).append(",");
        }
        if (this.getSchedules() != null) {
            sb.append("Schedules: ").append(this.getSchedules()).append(",");
        }
        if (this.getParameters() != null) {
            sb.append("Parameters: ").append(this.getParameters()).append(",");
        }
        if (this.getEventSource() != null) {
            sb.append("EventSource: ").append(this.getEventSource()).append(",");
        }
        if (this.getActions() != null) {
            sb.append("Actions: ").append(this.getActions()).append(",");
        }
        if (this.getPolicyLanguage() != null) {
            sb.append("PolicyLanguage: ").append(this.getPolicyLanguage()).append(",");
        }
        if (this.getResourceType() != null) {
            sb.append("ResourceType: ").append(this.getResourceType()).append(",");
        }
        if (this.getCreateInterval() != null) {
            sb.append("CreateInterval: ").append(this.getCreateInterval()).append(",");
        }
        if (this.getRetainInterval() != null) {
            sb.append("RetainInterval: ").append(this.getRetainInterval()).append(",");
        }
        if (this.getCopyTags() != null) {
            sb.append("CopyTags: ").append(this.getCopyTags()).append(",");
        }
        if (this.getCrossRegionCopyTargets() != null) {
            sb.append("CrossRegionCopyTargets: ").append(this.getCrossRegionCopyTargets()).append(",");
        }
        if (this.getExtendDeletion() != null) {
            sb.append("ExtendDeletion: ").append(this.getExtendDeletion()).append(",");
        }
        if (this.getExclusions() != null) {
            sb.append("Exclusions: ").append(this.getExclusions());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PolicyDetails)) {
            return false;
        }
        PolicyDetails other = (PolicyDetails)obj;
        if (other.getPolicyType() == null ^ this.getPolicyType() == null) {
            return false;
        }
        if (other.getPolicyType() != null && !other.getPolicyType().equals(this.getPolicyType())) {
            return false;
        }
        if (other.getResourceTypes() == null ^ this.getResourceTypes() == null) {
            return false;
        }
        if (other.getResourceTypes() != null && !other.getResourceTypes().equals(this.getResourceTypes())) {
            return false;
        }
        if (other.getResourceLocations() == null ^ this.getResourceLocations() == null) {
            return false;
        }
        if (other.getResourceLocations() != null && !other.getResourceLocations().equals(this.getResourceLocations())) {
            return false;
        }
        if (other.getTargetTags() == null ^ this.getTargetTags() == null) {
            return false;
        }
        if (other.getTargetTags() != null && !other.getTargetTags().equals(this.getTargetTags())) {
            return false;
        }
        if (other.getSchedules() == null ^ this.getSchedules() == null) {
            return false;
        }
        if (other.getSchedules() != null && !other.getSchedules().equals(this.getSchedules())) {
            return false;
        }
        if (other.getParameters() == null ^ this.getParameters() == null) {
            return false;
        }
        if (other.getParameters() != null && !other.getParameters().equals(this.getParameters())) {
            return false;
        }
        if (other.getEventSource() == null ^ this.getEventSource() == null) {
            return false;
        }
        if (other.getEventSource() != null && !other.getEventSource().equals(this.getEventSource())) {
            return false;
        }
        if (other.getActions() == null ^ this.getActions() == null) {
            return false;
        }
        if (other.getActions() != null && !other.getActions().equals(this.getActions())) {
            return false;
        }
        if (other.getPolicyLanguage() == null ^ this.getPolicyLanguage() == null) {
            return false;
        }
        if (other.getPolicyLanguage() != null && !other.getPolicyLanguage().equals(this.getPolicyLanguage())) {
            return false;
        }
        if (other.getResourceType() == null ^ this.getResourceType() == null) {
            return false;
        }
        if (other.getResourceType() != null && !other.getResourceType().equals(this.getResourceType())) {
            return false;
        }
        if (other.getCreateInterval() == null ^ this.getCreateInterval() == null) {
            return false;
        }
        if (other.getCreateInterval() != null && !other.getCreateInterval().equals(this.getCreateInterval())) {
            return false;
        }
        if (other.getRetainInterval() == null ^ this.getRetainInterval() == null) {
            return false;
        }
        if (other.getRetainInterval() != null && !other.getRetainInterval().equals(this.getRetainInterval())) {
            return false;
        }
        if (other.getCopyTags() == null ^ this.getCopyTags() == null) {
            return false;
        }
        if (other.getCopyTags() != null && !other.getCopyTags().equals(this.getCopyTags())) {
            return false;
        }
        if (other.getCrossRegionCopyTargets() == null ^ this.getCrossRegionCopyTargets() == null) {
            return false;
        }
        if (other.getCrossRegionCopyTargets() != null && !other.getCrossRegionCopyTargets().equals(this.getCrossRegionCopyTargets())) {
            return false;
        }
        if (other.getExtendDeletion() == null ^ this.getExtendDeletion() == null) {
            return false;
        }
        if (other.getExtendDeletion() != null && !other.getExtendDeletion().equals(this.getExtendDeletion())) {
            return false;
        }
        if (other.getExclusions() == null ^ this.getExclusions() == null) {
            return false;
        }
        return other.getExclusions() == null || other.getExclusions().equals(this.getExclusions());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getPolicyType() == null ? 0 : this.getPolicyType().hashCode());
        hashCode = 31 * hashCode + (this.getResourceTypes() == null ? 0 : this.getResourceTypes().hashCode());
        hashCode = 31 * hashCode + (this.getResourceLocations() == null ? 0 : this.getResourceLocations().hashCode());
        hashCode = 31 * hashCode + (this.getTargetTags() == null ? 0 : this.getTargetTags().hashCode());
        hashCode = 31 * hashCode + (this.getSchedules() == null ? 0 : this.getSchedules().hashCode());
        hashCode = 31 * hashCode + (this.getParameters() == null ? 0 : this.getParameters().hashCode());
        hashCode = 31 * hashCode + (this.getEventSource() == null ? 0 : this.getEventSource().hashCode());
        hashCode = 31 * hashCode + (this.getActions() == null ? 0 : this.getActions().hashCode());
        hashCode = 31 * hashCode + (this.getPolicyLanguage() == null ? 0 : this.getPolicyLanguage().hashCode());
        hashCode = 31 * hashCode + (this.getResourceType() == null ? 0 : this.getResourceType().hashCode());
        hashCode = 31 * hashCode + (this.getCreateInterval() == null ? 0 : this.getCreateInterval().hashCode());
        hashCode = 31 * hashCode + (this.getRetainInterval() == null ? 0 : this.getRetainInterval().hashCode());
        hashCode = 31 * hashCode + (this.getCopyTags() == null ? 0 : this.getCopyTags().hashCode());
        hashCode = 31 * hashCode + (this.getCrossRegionCopyTargets() == null ? 0 : this.getCrossRegionCopyTargets().hashCode());
        hashCode = 31 * hashCode + (this.getExtendDeletion() == null ? 0 : this.getExtendDeletion().hashCode());
        hashCode = 31 * hashCode + (this.getExclusions() == null ? 0 : this.getExclusions().hashCode());
        return hashCode;
    }

    public PolicyDetails clone() {
        try {
            return (PolicyDetails)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        PolicyDetailsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

