/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dlm;

import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfigurationFactory;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.client.builder.AdvancedConfig;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.handlers.HandlerContextKey;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.metrics.MetricType;
import com.amazonaws.protocol.json.JsonClientMetadata;
import com.amazonaws.protocol.json.JsonErrorResponseMetadata;
import com.amazonaws.protocol.json.JsonErrorShapeMetadata;
import com.amazonaws.protocol.json.JsonOperationMetadata;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.dlm.AmazonDLM;
import com.amazonaws.services.dlm.AmazonDLMClientBuilder;
import com.amazonaws.services.dlm.model.AmazonDLMException;
import com.amazonaws.services.dlm.model.CreateLifecyclePolicyRequest;
import com.amazonaws.services.dlm.model.CreateLifecyclePolicyResult;
import com.amazonaws.services.dlm.model.DeleteLifecyclePolicyRequest;
import com.amazonaws.services.dlm.model.DeleteLifecyclePolicyResult;
import com.amazonaws.services.dlm.model.GetLifecyclePoliciesRequest;
import com.amazonaws.services.dlm.model.GetLifecyclePoliciesResult;
import com.amazonaws.services.dlm.model.GetLifecyclePolicyRequest;
import com.amazonaws.services.dlm.model.GetLifecyclePolicyResult;
import com.amazonaws.services.dlm.model.UpdateLifecyclePolicyRequest;
import com.amazonaws.services.dlm.model.UpdateLifecyclePolicyResult;
import com.amazonaws.services.dlm.model.transform.CreateLifecyclePolicyRequestProtocolMarshaller;
import com.amazonaws.services.dlm.model.transform.CreateLifecyclePolicyResultJsonUnmarshaller;
import com.amazonaws.services.dlm.model.transform.DeleteLifecyclePolicyRequestProtocolMarshaller;
import com.amazonaws.services.dlm.model.transform.DeleteLifecyclePolicyResultJsonUnmarshaller;
import com.amazonaws.services.dlm.model.transform.GetLifecyclePoliciesRequestProtocolMarshaller;
import com.amazonaws.services.dlm.model.transform.GetLifecyclePoliciesResultJsonUnmarshaller;
import com.amazonaws.services.dlm.model.transform.GetLifecyclePolicyRequestProtocolMarshaller;
import com.amazonaws.services.dlm.model.transform.GetLifecyclePolicyResultJsonUnmarshaller;
import com.amazonaws.services.dlm.model.transform.InternalServerExceptionUnmarshaller;
import com.amazonaws.services.dlm.model.transform.InvalidRequestExceptionUnmarshaller;
import com.amazonaws.services.dlm.model.transform.LimitExceededExceptionUnmarshaller;
import com.amazonaws.services.dlm.model.transform.ResourceNotFoundExceptionUnmarshaller;
import com.amazonaws.services.dlm.model.transform.UpdateLifecyclePolicyRequestProtocolMarshaller;
import com.amazonaws.services.dlm.model.transform.UpdateLifecyclePolicyResultJsonUnmarshaller;
import com.amazonaws.transform.JsonBaseExceptionUnmarshaller;
import com.amazonaws.transform.JsonErrorUnmarshaller;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.CredentialUtils;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@ThreadSafe
public class AmazonDLMClient
extends AmazonWebServiceClient
implements AmazonDLM {
    private final AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AmazonDLM.class);
    private static final String DEFAULT_SIGNING_NAME = "dlm";
    protected static final ClientConfigurationFactory configFactory = new ClientConfigurationFactory();
    private final AdvancedConfig advancedConfig;
    private static final SdkJsonProtocolFactory protocolFactory = new SdkJsonProtocolFactory(new JsonClientMetadata().withProtocolVersion("1.1").withSupportsCbor(false).withSupportsIon(false).withContentTypeOverride("").addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidRequestException").withExceptionUnmarshaller((JsonErrorUnmarshaller)InvalidRequestExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ResourceNotFoundException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ResourceNotFoundExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InternalServerException").withExceptionUnmarshaller((JsonErrorUnmarshaller)InternalServerExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("LimitExceededException").withExceptionUnmarshaller((JsonErrorUnmarshaller)LimitExceededExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode(null).withExceptionUnmarshaller((JsonErrorUnmarshaller)new JsonBaseExceptionUnmarshaller(AmazonDLMException.class))));

    public static AmazonDLMClientBuilder builder() {
        return AmazonDLMClientBuilder.standard();
    }

    AmazonDLMClient(AwsSyncClientParams clientParams) {
        this(clientParams, false);
    }

    AmazonDLMClient(AwsSyncClientParams clientParams, boolean endpointDiscoveryEnabled) {
        super(clientParams);
        this.awsCredentialsProvider = clientParams.getCredentialsProvider();
        this.advancedConfig = clientParams.getAdvancedConfig();
        this.init();
    }

    private void init() {
        this.setServiceNameIntern(DEFAULT_SIGNING_NAME);
        this.setEndpointPrefix(DEFAULT_SIGNING_NAME);
        this.setEndpoint("dlm.us-east-1.amazonaws.com");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/dlm/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/amazonaws/services/dlm/request.handler2s"));
        this.requestHandler2s.addAll(chainFactory.getGlobalHandlers());
    }

    @Override
    public CreateLifecyclePolicyResult createLifecyclePolicy(CreateLifecyclePolicyRequest request) {
        request = (CreateLifecyclePolicyRequest)this.beforeClientExecution(request);
        return this.executeCreateLifecyclePolicy(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateLifecyclePolicyResult executeCreateLifecyclePolicy(CreateLifecyclePolicyRequest createLifecyclePolicyRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createLifecyclePolicyRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateLifecyclePolicyRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateLifecyclePolicyRequestProtocolMarshaller(protocolFactory).marshall((CreateLifecyclePolicyRequest)super.beforeMarshalling((AmazonWebServiceRequest)createLifecyclePolicyRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"DLM");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreateLifecyclePolicy");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateLifecyclePolicyResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateLifecyclePolicyResult createLifecyclePolicyResult = (CreateLifecyclePolicyResult)response.getAwsResponse();
            return createLifecyclePolicyResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteLifecyclePolicyResult deleteLifecyclePolicy(DeleteLifecyclePolicyRequest request) {
        request = (DeleteLifecyclePolicyRequest)this.beforeClientExecution(request);
        return this.executeDeleteLifecyclePolicy(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteLifecyclePolicyResult executeDeleteLifecyclePolicy(DeleteLifecyclePolicyRequest deleteLifecyclePolicyRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteLifecyclePolicyRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteLifecyclePolicyRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteLifecyclePolicyRequestProtocolMarshaller(protocolFactory).marshall((DeleteLifecyclePolicyRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteLifecyclePolicyRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"DLM");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteLifecyclePolicy");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteLifecyclePolicyResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteLifecyclePolicyResult deleteLifecyclePolicyResult = (DeleteLifecyclePolicyResult)response.getAwsResponse();
            return deleteLifecyclePolicyResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetLifecyclePoliciesResult getLifecyclePolicies(GetLifecyclePoliciesRequest request) {
        request = (GetLifecyclePoliciesRequest)this.beforeClientExecution(request);
        return this.executeGetLifecyclePolicies(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetLifecyclePoliciesResult executeGetLifecyclePolicies(GetLifecyclePoliciesRequest getLifecyclePoliciesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getLifecyclePoliciesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetLifecyclePoliciesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetLifecyclePoliciesRequestProtocolMarshaller(protocolFactory).marshall((GetLifecyclePoliciesRequest)super.beforeMarshalling((AmazonWebServiceRequest)getLifecyclePoliciesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"DLM");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetLifecyclePolicies");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetLifecyclePoliciesResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetLifecyclePoliciesResult getLifecyclePoliciesResult = (GetLifecyclePoliciesResult)response.getAwsResponse();
            return getLifecyclePoliciesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetLifecyclePolicyResult getLifecyclePolicy(GetLifecyclePolicyRequest request) {
        request = (GetLifecyclePolicyRequest)this.beforeClientExecution(request);
        return this.executeGetLifecyclePolicy(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetLifecyclePolicyResult executeGetLifecyclePolicy(GetLifecyclePolicyRequest getLifecyclePolicyRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getLifecyclePolicyRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetLifecyclePolicyRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetLifecyclePolicyRequestProtocolMarshaller(protocolFactory).marshall((GetLifecyclePolicyRequest)super.beforeMarshalling((AmazonWebServiceRequest)getLifecyclePolicyRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"DLM");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetLifecyclePolicy");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetLifecyclePolicyResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetLifecyclePolicyResult getLifecyclePolicyResult = (GetLifecyclePolicyResult)response.getAwsResponse();
            return getLifecyclePolicyResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateLifecyclePolicyResult updateLifecyclePolicy(UpdateLifecyclePolicyRequest request) {
        request = (UpdateLifecyclePolicyRequest)this.beforeClientExecution(request);
        return this.executeUpdateLifecyclePolicy(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateLifecyclePolicyResult executeUpdateLifecyclePolicy(UpdateLifecyclePolicyRequest updateLifecyclePolicyRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateLifecyclePolicyRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateLifecyclePolicyRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateLifecyclePolicyRequestProtocolMarshaller(protocolFactory).marshall((UpdateLifecyclePolicyRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateLifecyclePolicyRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"DLM");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UpdateLifecyclePolicy");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateLifecyclePolicyResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateLifecyclePolicyResult updateLifecyclePolicyResult = (UpdateLifecyclePolicyResult)response.getAwsResponse();
            return updateLifecyclePolicyResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.invoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI cachedEndpoint, URI uriFromEndpointTrait) {
        executionContext.setCredentialsProvider(CredentialUtils.getCredentialsProvider((AmazonWebServiceRequest)request.getOriginalRequest(), (AWSCredentialsProvider)this.awsCredentialsProvider));
        return this.doInvoke(request, responseHandler, executionContext, cachedEndpoint, uriFromEndpointTrait);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> anonymousInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.doInvoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> doInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI discoveredEndpoint, URI uriFromEndpointTrait) {
        if (discoveredEndpoint != null) {
            request.setEndpoint(discoveredEndpoint);
            request.getOriginalRequest().getRequestClientOptions().appendUserAgent("endpoint-discovery");
        } else if (uriFromEndpointTrait != null) {
            request.setEndpoint(uriFromEndpointTrait);
        } else {
            request.setEndpoint(this.endpoint);
        }
        request.setTimeOffset(this.timeOffset);
        HttpResponseHandler errorResponseHandler = protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
        return this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
    }

    @SdkInternalApi
    static SdkJsonProtocolFactory getProtocolFactory() {
        return protocolFactory;
    }
}

