/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dlm.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.dlm.model.IntervalUnitValues;
import com.amazonaws.services.dlm.model.transform.CreateRuleMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CreateRule
implements Serializable,
Cloneable,
StructuredPojo {
    private Integer interval;
    private String intervalUnit;
    private List<String> times;

    public void setInterval(Integer interval) {
        this.interval = interval;
    }

    public Integer getInterval() {
        return this.interval;
    }

    public CreateRule withInterval(Integer interval) {
        this.setInterval(interval);
        return this;
    }

    public void setIntervalUnit(String intervalUnit) {
        this.intervalUnit = intervalUnit;
    }

    public String getIntervalUnit() {
        return this.intervalUnit;
    }

    public CreateRule withIntervalUnit(String intervalUnit) {
        this.setIntervalUnit(intervalUnit);
        return this;
    }

    public CreateRule withIntervalUnit(IntervalUnitValues intervalUnit) {
        this.intervalUnit = intervalUnit.toString();
        return this;
    }

    public List<String> getTimes() {
        return this.times;
    }

    public void setTimes(Collection<String> times) {
        if (times == null) {
            this.times = null;
            return;
        }
        this.times = new ArrayList<String>(times);
    }

    public CreateRule withTimes(String ... times) {
        if (this.times == null) {
            this.setTimes(new ArrayList<String>(times.length));
        }
        for (String ele : times) {
            this.times.add(ele);
        }
        return this;
    }

    public CreateRule withTimes(Collection<String> times) {
        this.setTimes(times);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getInterval() != null) {
            sb.append("Interval: ").append(this.getInterval()).append(",");
        }
        if (this.getIntervalUnit() != null) {
            sb.append("IntervalUnit: ").append(this.getIntervalUnit()).append(",");
        }
        if (this.getTimes() != null) {
            sb.append("Times: ").append(this.getTimes());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateRule)) {
            return false;
        }
        CreateRule other = (CreateRule)obj;
        if (other.getInterval() == null ^ this.getInterval() == null) {
            return false;
        }
        if (other.getInterval() != null && !other.getInterval().equals(this.getInterval())) {
            return false;
        }
        if (other.getIntervalUnit() == null ^ this.getIntervalUnit() == null) {
            return false;
        }
        if (other.getIntervalUnit() != null && !other.getIntervalUnit().equals(this.getIntervalUnit())) {
            return false;
        }
        if (other.getTimes() == null ^ this.getTimes() == null) {
            return false;
        }
        return other.getTimes() == null || other.getTimes().equals(this.getTimes());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getInterval() == null ? 0 : this.getInterval().hashCode());
        hashCode = 31 * hashCode + (this.getIntervalUnit() == null ? 0 : this.getIntervalUnit().hashCode());
        hashCode = 31 * hashCode + (this.getTimes() == null ? 0 : this.getTimes().hashCode());
        return hashCode;
    }

    public CreateRule clone() {
        try {
            return (CreateRule)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        CreateRuleMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

