/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.applicationdiscovery.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.applicationdiscovery.model.DescribeExportConfigurationsRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.List;

public class DescribeExportConfigurationsRequestMarshaller
implements Marshaller<Request<DescribeExportConfigurationsRequest>, DescribeExportConfigurationsRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public DescribeExportConfigurationsRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<DescribeExportConfigurationsRequest> marshall(DescribeExportConfigurationsRequest describeExportConfigurationsRequest) {
        if (describeExportConfigurationsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeExportConfigurationsRequest, "AWSApplicationDiscovery");
        request.addHeader("X-Amz-Target", "AWSPoseidonService_V2015_11_01.DescribeExportConfigurations");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            List<String> exportIdsList = describeExportConfigurationsRequest.getExportIds();
            if (exportIdsList != null) {
                jsonGenerator.writeFieldName("exportIds");
                jsonGenerator.writeStartArray();
                for (String exportIdsListValue : exportIdsList) {
                    if (exportIdsListValue == null) continue;
                    jsonGenerator.writeValue(exportIdsListValue);
                }
                jsonGenerator.writeEndArray();
            }
            if (describeExportConfigurationsRequest.getMaxResults() != null) {
                jsonGenerator.writeFieldName("maxResults").writeValue(describeExportConfigurationsRequest.getMaxResults().intValue());
            }
            if (describeExportConfigurationsRequest.getNextToken() != null) {
                jsonGenerator.writeFieldName("nextToken").writeValue(describeExportConfigurationsRequest.getNextToken());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", jsonGenerator.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

