/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.applicationdiscovery;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.applicationdiscovery.AWSApplicationDiscoveryAsync;
import com.amazonaws.services.applicationdiscovery.AWSApplicationDiscoveryAsyncClientBuilder;
import com.amazonaws.services.applicationdiscovery.AWSApplicationDiscoveryClient;
import com.amazonaws.services.applicationdiscovery.model.AssociateConfigurationItemsToApplicationRequest;
import com.amazonaws.services.applicationdiscovery.model.AssociateConfigurationItemsToApplicationResult;
import com.amazonaws.services.applicationdiscovery.model.CreateApplicationRequest;
import com.amazonaws.services.applicationdiscovery.model.CreateApplicationResult;
import com.amazonaws.services.applicationdiscovery.model.CreateTagsRequest;
import com.amazonaws.services.applicationdiscovery.model.CreateTagsResult;
import com.amazonaws.services.applicationdiscovery.model.DeleteApplicationsRequest;
import com.amazonaws.services.applicationdiscovery.model.DeleteApplicationsResult;
import com.amazonaws.services.applicationdiscovery.model.DeleteTagsRequest;
import com.amazonaws.services.applicationdiscovery.model.DeleteTagsResult;
import com.amazonaws.services.applicationdiscovery.model.DescribeAgentsRequest;
import com.amazonaws.services.applicationdiscovery.model.DescribeAgentsResult;
import com.amazonaws.services.applicationdiscovery.model.DescribeConfigurationsRequest;
import com.amazonaws.services.applicationdiscovery.model.DescribeConfigurationsResult;
import com.amazonaws.services.applicationdiscovery.model.DescribeExportConfigurationsRequest;
import com.amazonaws.services.applicationdiscovery.model.DescribeExportConfigurationsResult;
import com.amazonaws.services.applicationdiscovery.model.DescribeExportTasksRequest;
import com.amazonaws.services.applicationdiscovery.model.DescribeExportTasksResult;
import com.amazonaws.services.applicationdiscovery.model.DescribeTagsRequest;
import com.amazonaws.services.applicationdiscovery.model.DescribeTagsResult;
import com.amazonaws.services.applicationdiscovery.model.DisassociateConfigurationItemsFromApplicationRequest;
import com.amazonaws.services.applicationdiscovery.model.DisassociateConfigurationItemsFromApplicationResult;
import com.amazonaws.services.applicationdiscovery.model.ExportConfigurationsRequest;
import com.amazonaws.services.applicationdiscovery.model.ExportConfigurationsResult;
import com.amazonaws.services.applicationdiscovery.model.GetDiscoverySummaryRequest;
import com.amazonaws.services.applicationdiscovery.model.GetDiscoverySummaryResult;
import com.amazonaws.services.applicationdiscovery.model.ListConfigurationsRequest;
import com.amazonaws.services.applicationdiscovery.model.ListConfigurationsResult;
import com.amazonaws.services.applicationdiscovery.model.ListServerNeighborsRequest;
import com.amazonaws.services.applicationdiscovery.model.ListServerNeighborsResult;
import com.amazonaws.services.applicationdiscovery.model.StartDataCollectionByAgentIdsRequest;
import com.amazonaws.services.applicationdiscovery.model.StartDataCollectionByAgentIdsResult;
import com.amazonaws.services.applicationdiscovery.model.StartExportTaskRequest;
import com.amazonaws.services.applicationdiscovery.model.StartExportTaskResult;
import com.amazonaws.services.applicationdiscovery.model.StopDataCollectionByAgentIdsRequest;
import com.amazonaws.services.applicationdiscovery.model.StopDataCollectionByAgentIdsResult;
import com.amazonaws.services.applicationdiscovery.model.UpdateApplicationRequest;
import com.amazonaws.services.applicationdiscovery.model.UpdateApplicationResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

@ThreadSafe
public class AWSApplicationDiscoveryAsyncClient
extends AWSApplicationDiscoveryClient
implements AWSApplicationDiscoveryAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    @Deprecated
    public AWSApplicationDiscoveryAsyncClient() {
        this((AWSCredentialsProvider)DefaultAWSCredentialsProviderChain.getInstance());
    }

    @Deprecated
    public AWSApplicationDiscoveryAsyncClient(ClientConfiguration clientConfiguration) {
        this((AWSCredentialsProvider)DefaultAWSCredentialsProviderChain.getInstance(), clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    @Deprecated
    public AWSApplicationDiscoveryAsyncClient(AWSCredentials awsCredentials) {
        this(awsCredentials, Executors.newFixedThreadPool(50));
    }

    @Deprecated
    public AWSApplicationDiscoveryAsyncClient(AWSCredentials awsCredentials, ExecutorService executorService) {
        this(awsCredentials, configFactory.getConfig(), executorService);
    }

    @Deprecated
    public AWSApplicationDiscoveryAsyncClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentials, clientConfiguration);
        this.executorService = executorService;
    }

    @Deprecated
    public AWSApplicationDiscoveryAsyncClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, Executors.newFixedThreadPool(50));
    }

    @Deprecated
    public AWSApplicationDiscoveryAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    @Deprecated
    public AWSApplicationDiscoveryAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ExecutorService executorService) {
        this(awsCredentialsProvider, configFactory.getConfig(), executorService);
    }

    @Deprecated
    public AWSApplicationDiscoveryAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentialsProvider, clientConfiguration);
        this.executorService = executorService;
    }

    public static AWSApplicationDiscoveryAsyncClientBuilder asyncBuilder() {
        return AWSApplicationDiscoveryAsyncClientBuilder.standard();
    }

    AWSApplicationDiscoveryAsyncClient(AwsAsyncClientParams asyncClientParams) {
        super((AwsSyncClientParams)asyncClientParams);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<AssociateConfigurationItemsToApplicationResult> associateConfigurationItemsToApplicationAsync(AssociateConfigurationItemsToApplicationRequest request) {
        return this.associateConfigurationItemsToApplicationAsync(request, null);
    }

    @Override
    public Future<AssociateConfigurationItemsToApplicationResult> associateConfigurationItemsToApplicationAsync(AssociateConfigurationItemsToApplicationRequest request, final AsyncHandler<AssociateConfigurationItemsToApplicationRequest, AssociateConfigurationItemsToApplicationResult> asyncHandler) {
        final AssociateConfigurationItemsToApplicationRequest finalRequest = (AssociateConfigurationItemsToApplicationRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<AssociateConfigurationItemsToApplicationResult>(){

            @Override
            public AssociateConfigurationItemsToApplicationResult call() throws Exception {
                AssociateConfigurationItemsToApplicationResult result = null;
                try {
                    result = AWSApplicationDiscoveryAsyncClient.this.executeAssociateConfigurationItemsToApplication(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateApplicationResult> createApplicationAsync(CreateApplicationRequest request) {
        return this.createApplicationAsync(request, null);
    }

    @Override
    public Future<CreateApplicationResult> createApplicationAsync(CreateApplicationRequest request, final AsyncHandler<CreateApplicationRequest, CreateApplicationResult> asyncHandler) {
        final CreateApplicationRequest finalRequest = (CreateApplicationRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateApplicationResult>(){

            @Override
            public CreateApplicationResult call() throws Exception {
                CreateApplicationResult result = null;
                try {
                    result = AWSApplicationDiscoveryAsyncClient.this.executeCreateApplication(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateTagsResult> createTagsAsync(CreateTagsRequest request) {
        return this.createTagsAsync(request, null);
    }

    @Override
    public Future<CreateTagsResult> createTagsAsync(CreateTagsRequest request, final AsyncHandler<CreateTagsRequest, CreateTagsResult> asyncHandler) {
        final CreateTagsRequest finalRequest = (CreateTagsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateTagsResult>(){

            @Override
            public CreateTagsResult call() throws Exception {
                CreateTagsResult result = null;
                try {
                    result = AWSApplicationDiscoveryAsyncClient.this.executeCreateTags(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteApplicationsResult> deleteApplicationsAsync(DeleteApplicationsRequest request) {
        return this.deleteApplicationsAsync(request, null);
    }

    @Override
    public Future<DeleteApplicationsResult> deleteApplicationsAsync(DeleteApplicationsRequest request, final AsyncHandler<DeleteApplicationsRequest, DeleteApplicationsResult> asyncHandler) {
        final DeleteApplicationsRequest finalRequest = (DeleteApplicationsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteApplicationsResult>(){

            @Override
            public DeleteApplicationsResult call() throws Exception {
                DeleteApplicationsResult result = null;
                try {
                    result = AWSApplicationDiscoveryAsyncClient.this.executeDeleteApplications(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteTagsResult> deleteTagsAsync(DeleteTagsRequest request) {
        return this.deleteTagsAsync(request, null);
    }

    @Override
    public Future<DeleteTagsResult> deleteTagsAsync(DeleteTagsRequest request, final AsyncHandler<DeleteTagsRequest, DeleteTagsResult> asyncHandler) {
        final DeleteTagsRequest finalRequest = (DeleteTagsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteTagsResult>(){

            @Override
            public DeleteTagsResult call() throws Exception {
                DeleteTagsResult result = null;
                try {
                    result = AWSApplicationDiscoveryAsyncClient.this.executeDeleteTags(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeAgentsResult> describeAgentsAsync(DescribeAgentsRequest request) {
        return this.describeAgentsAsync(request, null);
    }

    @Override
    public Future<DescribeAgentsResult> describeAgentsAsync(DescribeAgentsRequest request, final AsyncHandler<DescribeAgentsRequest, DescribeAgentsResult> asyncHandler) {
        final DescribeAgentsRequest finalRequest = (DescribeAgentsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeAgentsResult>(){

            @Override
            public DescribeAgentsResult call() throws Exception {
                DescribeAgentsResult result = null;
                try {
                    result = AWSApplicationDiscoveryAsyncClient.this.executeDescribeAgents(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeConfigurationsResult> describeConfigurationsAsync(DescribeConfigurationsRequest request) {
        return this.describeConfigurationsAsync(request, null);
    }

    @Override
    public Future<DescribeConfigurationsResult> describeConfigurationsAsync(DescribeConfigurationsRequest request, final AsyncHandler<DescribeConfigurationsRequest, DescribeConfigurationsResult> asyncHandler) {
        final DescribeConfigurationsRequest finalRequest = (DescribeConfigurationsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeConfigurationsResult>(){

            @Override
            public DescribeConfigurationsResult call() throws Exception {
                DescribeConfigurationsResult result = null;
                try {
                    result = AWSApplicationDiscoveryAsyncClient.this.executeDescribeConfigurations(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    @Deprecated
    public Future<DescribeExportConfigurationsResult> describeExportConfigurationsAsync(DescribeExportConfigurationsRequest request) {
        return this.describeExportConfigurationsAsync(request, null);
    }

    @Override
    @Deprecated
    public Future<DescribeExportConfigurationsResult> describeExportConfigurationsAsync(DescribeExportConfigurationsRequest request, final AsyncHandler<DescribeExportConfigurationsRequest, DescribeExportConfigurationsResult> asyncHandler) {
        final DescribeExportConfigurationsRequest finalRequest = (DescribeExportConfigurationsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeExportConfigurationsResult>(){

            @Override
            public DescribeExportConfigurationsResult call() throws Exception {
                DescribeExportConfigurationsResult result = null;
                try {
                    result = AWSApplicationDiscoveryAsyncClient.this.executeDescribeExportConfigurations(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeExportTasksResult> describeExportTasksAsync(DescribeExportTasksRequest request) {
        return this.describeExportTasksAsync(request, null);
    }

    @Override
    public Future<DescribeExportTasksResult> describeExportTasksAsync(DescribeExportTasksRequest request, final AsyncHandler<DescribeExportTasksRequest, DescribeExportTasksResult> asyncHandler) {
        final DescribeExportTasksRequest finalRequest = (DescribeExportTasksRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeExportTasksResult>(){

            @Override
            public DescribeExportTasksResult call() throws Exception {
                DescribeExportTasksResult result = null;
                try {
                    result = AWSApplicationDiscoveryAsyncClient.this.executeDescribeExportTasks(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeTagsResult> describeTagsAsync(DescribeTagsRequest request) {
        return this.describeTagsAsync(request, null);
    }

    @Override
    public Future<DescribeTagsResult> describeTagsAsync(DescribeTagsRequest request, final AsyncHandler<DescribeTagsRequest, DescribeTagsResult> asyncHandler) {
        final DescribeTagsRequest finalRequest = (DescribeTagsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeTagsResult>(){

            @Override
            public DescribeTagsResult call() throws Exception {
                DescribeTagsResult result = null;
                try {
                    result = AWSApplicationDiscoveryAsyncClient.this.executeDescribeTags(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DisassociateConfigurationItemsFromApplicationResult> disassociateConfigurationItemsFromApplicationAsync(DisassociateConfigurationItemsFromApplicationRequest request) {
        return this.disassociateConfigurationItemsFromApplicationAsync(request, null);
    }

    @Override
    public Future<DisassociateConfigurationItemsFromApplicationResult> disassociateConfigurationItemsFromApplicationAsync(DisassociateConfigurationItemsFromApplicationRequest request, final AsyncHandler<DisassociateConfigurationItemsFromApplicationRequest, DisassociateConfigurationItemsFromApplicationResult> asyncHandler) {
        final DisassociateConfigurationItemsFromApplicationRequest finalRequest = (DisassociateConfigurationItemsFromApplicationRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DisassociateConfigurationItemsFromApplicationResult>(){

            @Override
            public DisassociateConfigurationItemsFromApplicationResult call() throws Exception {
                DisassociateConfigurationItemsFromApplicationResult result = null;
                try {
                    result = AWSApplicationDiscoveryAsyncClient.this.executeDisassociateConfigurationItemsFromApplication(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    @Deprecated
    public Future<ExportConfigurationsResult> exportConfigurationsAsync(ExportConfigurationsRequest request) {
        return this.exportConfigurationsAsync(request, null);
    }

    @Override
    @Deprecated
    public Future<ExportConfigurationsResult> exportConfigurationsAsync(ExportConfigurationsRequest request, final AsyncHandler<ExportConfigurationsRequest, ExportConfigurationsResult> asyncHandler) {
        final ExportConfigurationsRequest finalRequest = (ExportConfigurationsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ExportConfigurationsResult>(){

            @Override
            public ExportConfigurationsResult call() throws Exception {
                ExportConfigurationsResult result = null;
                try {
                    result = AWSApplicationDiscoveryAsyncClient.this.executeExportConfigurations(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetDiscoverySummaryResult> getDiscoverySummaryAsync(GetDiscoverySummaryRequest request) {
        return this.getDiscoverySummaryAsync(request, null);
    }

    @Override
    public Future<GetDiscoverySummaryResult> getDiscoverySummaryAsync(GetDiscoverySummaryRequest request, final AsyncHandler<GetDiscoverySummaryRequest, GetDiscoverySummaryResult> asyncHandler) {
        final GetDiscoverySummaryRequest finalRequest = (GetDiscoverySummaryRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetDiscoverySummaryResult>(){

            @Override
            public GetDiscoverySummaryResult call() throws Exception {
                GetDiscoverySummaryResult result = null;
                try {
                    result = AWSApplicationDiscoveryAsyncClient.this.executeGetDiscoverySummary(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListConfigurationsResult> listConfigurationsAsync(ListConfigurationsRequest request) {
        return this.listConfigurationsAsync(request, null);
    }

    @Override
    public Future<ListConfigurationsResult> listConfigurationsAsync(ListConfigurationsRequest request, final AsyncHandler<ListConfigurationsRequest, ListConfigurationsResult> asyncHandler) {
        final ListConfigurationsRequest finalRequest = (ListConfigurationsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListConfigurationsResult>(){

            @Override
            public ListConfigurationsResult call() throws Exception {
                ListConfigurationsResult result = null;
                try {
                    result = AWSApplicationDiscoveryAsyncClient.this.executeListConfigurations(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListServerNeighborsResult> listServerNeighborsAsync(ListServerNeighborsRequest request) {
        return this.listServerNeighborsAsync(request, null);
    }

    @Override
    public Future<ListServerNeighborsResult> listServerNeighborsAsync(ListServerNeighborsRequest request, final AsyncHandler<ListServerNeighborsRequest, ListServerNeighborsResult> asyncHandler) {
        final ListServerNeighborsRequest finalRequest = (ListServerNeighborsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListServerNeighborsResult>(){

            @Override
            public ListServerNeighborsResult call() throws Exception {
                ListServerNeighborsResult result = null;
                try {
                    result = AWSApplicationDiscoveryAsyncClient.this.executeListServerNeighbors(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<StartDataCollectionByAgentIdsResult> startDataCollectionByAgentIdsAsync(StartDataCollectionByAgentIdsRequest request) {
        return this.startDataCollectionByAgentIdsAsync(request, null);
    }

    @Override
    public Future<StartDataCollectionByAgentIdsResult> startDataCollectionByAgentIdsAsync(StartDataCollectionByAgentIdsRequest request, final AsyncHandler<StartDataCollectionByAgentIdsRequest, StartDataCollectionByAgentIdsResult> asyncHandler) {
        final StartDataCollectionByAgentIdsRequest finalRequest = (StartDataCollectionByAgentIdsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<StartDataCollectionByAgentIdsResult>(){

            @Override
            public StartDataCollectionByAgentIdsResult call() throws Exception {
                StartDataCollectionByAgentIdsResult result = null;
                try {
                    result = AWSApplicationDiscoveryAsyncClient.this.executeStartDataCollectionByAgentIds(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<StartExportTaskResult> startExportTaskAsync(StartExportTaskRequest request) {
        return this.startExportTaskAsync(request, null);
    }

    @Override
    public Future<StartExportTaskResult> startExportTaskAsync(StartExportTaskRequest request, final AsyncHandler<StartExportTaskRequest, StartExportTaskResult> asyncHandler) {
        final StartExportTaskRequest finalRequest = (StartExportTaskRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<StartExportTaskResult>(){

            @Override
            public StartExportTaskResult call() throws Exception {
                StartExportTaskResult result = null;
                try {
                    result = AWSApplicationDiscoveryAsyncClient.this.executeStartExportTask(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<StopDataCollectionByAgentIdsResult> stopDataCollectionByAgentIdsAsync(StopDataCollectionByAgentIdsRequest request) {
        return this.stopDataCollectionByAgentIdsAsync(request, null);
    }

    @Override
    public Future<StopDataCollectionByAgentIdsResult> stopDataCollectionByAgentIdsAsync(StopDataCollectionByAgentIdsRequest request, final AsyncHandler<StopDataCollectionByAgentIdsRequest, StopDataCollectionByAgentIdsResult> asyncHandler) {
        final StopDataCollectionByAgentIdsRequest finalRequest = (StopDataCollectionByAgentIdsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<StopDataCollectionByAgentIdsResult>(){

            @Override
            public StopDataCollectionByAgentIdsResult call() throws Exception {
                StopDataCollectionByAgentIdsResult result = null;
                try {
                    result = AWSApplicationDiscoveryAsyncClient.this.executeStopDataCollectionByAgentIds(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateApplicationResult> updateApplicationAsync(UpdateApplicationRequest request) {
        return this.updateApplicationAsync(request, null);
    }

    @Override
    public Future<UpdateApplicationResult> updateApplicationAsync(UpdateApplicationRequest request, final AsyncHandler<UpdateApplicationRequest, UpdateApplicationResult> asyncHandler) {
        final UpdateApplicationRequest finalRequest = (UpdateApplicationRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateApplicationResult>(){

            @Override
            public UpdateApplicationResult call() throws Exception {
                UpdateApplicationResult result = null;
                try {
                    result = AWSApplicationDiscoveryAsyncClient.this.executeUpdateApplication(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

