/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.directory.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.directory.model.CreateDirectoryRequest;
import com.amazonaws.services.directory.model.transform.DirectoryVpcSettingsJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class CreateDirectoryRequestMarshaller
implements Marshaller<Request<CreateDirectoryRequest>, CreateDirectoryRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public CreateDirectoryRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<CreateDirectoryRequest> marshall(CreateDirectoryRequest createDirectoryRequest) {
        if (createDirectoryRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createDirectoryRequest, "AWSDirectoryService");
        request.addHeader("X-Amz-Target", "DirectoryService_20150416.CreateDirectory");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (createDirectoryRequest.getName() != null) {
                jsonGenerator.writeFieldName("Name").writeValue(createDirectoryRequest.getName());
            }
            if (createDirectoryRequest.getShortName() != null) {
                jsonGenerator.writeFieldName("ShortName").writeValue(createDirectoryRequest.getShortName());
            }
            if (createDirectoryRequest.getPassword() != null) {
                jsonGenerator.writeFieldName("Password").writeValue(createDirectoryRequest.getPassword());
            }
            if (createDirectoryRequest.getDescription() != null) {
                jsonGenerator.writeFieldName("Description").writeValue(createDirectoryRequest.getDescription());
            }
            if (createDirectoryRequest.getSize() != null) {
                jsonGenerator.writeFieldName("Size").writeValue(createDirectoryRequest.getSize());
            }
            if (createDirectoryRequest.getVpcSettings() != null) {
                jsonGenerator.writeFieldName("VpcSettings");
                DirectoryVpcSettingsJsonMarshaller.getInstance().marshall(createDirectoryRequest.getVpcSettings(), jsonGenerator);
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

