/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.directconnect.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.directconnect.model.Connection;
import com.amazonaws.services.directconnect.model.Lag;
import com.amazonaws.services.directconnect.model.transform.ConnectionJsonMarshaller;

public class LagJsonMarshaller {
    private static LagJsonMarshaller instance;

    public void marshall(Lag lag, StructuredJsonGenerator jsonGenerator) {
        if (lag == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            SdkInternalList connectionsList;
            jsonGenerator.writeStartObject();
            if (lag.getConnectionsBandwidth() != null) {
                jsonGenerator.writeFieldName("connectionsBandwidth").writeValue(lag.getConnectionsBandwidth());
            }
            if (lag.getNumberOfConnections() != null) {
                jsonGenerator.writeFieldName("numberOfConnections").writeValue(lag.getNumberOfConnections().intValue());
            }
            if (lag.getLagId() != null) {
                jsonGenerator.writeFieldName("lagId").writeValue(lag.getLagId());
            }
            if (lag.getOwnerAccount() != null) {
                jsonGenerator.writeFieldName("ownerAccount").writeValue(lag.getOwnerAccount());
            }
            if (lag.getLagName() != null) {
                jsonGenerator.writeFieldName("lagName").writeValue(lag.getLagName());
            }
            if (lag.getLagState() != null) {
                jsonGenerator.writeFieldName("lagState").writeValue(lag.getLagState());
            }
            if (lag.getLocation() != null) {
                jsonGenerator.writeFieldName("location").writeValue(lag.getLocation());
            }
            if (lag.getRegion() != null) {
                jsonGenerator.writeFieldName("region").writeValue(lag.getRegion());
            }
            if (lag.getMinimumLinks() != null) {
                jsonGenerator.writeFieldName("minimumLinks").writeValue(lag.getMinimumLinks().intValue());
            }
            if (lag.getAwsDevice() != null) {
                jsonGenerator.writeFieldName("awsDevice").writeValue(lag.getAwsDevice());
            }
            if (!(connectionsList = (SdkInternalList)lag.getConnections()).isEmpty() || !connectionsList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("connections");
                jsonGenerator.writeStartArray();
                for (Connection connectionsListValue : connectionsList) {
                    if (connectionsListValue == null) continue;
                    ConnectionJsonMarshaller.getInstance().marshall(connectionsListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            if (lag.getAllowsHostedConnections() != null) {
                jsonGenerator.writeFieldName("allowsHostedConnections").writeValue(lag.getAllowsHostedConnections().booleanValue());
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static LagJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new LagJsonMarshaller();
        }
        return instance;
    }
}

