/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.devicefarm.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.devicefarm.model.ListDevicePoolsRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class ListDevicePoolsRequestMarshaller
implements Marshaller<Request<ListDevicePoolsRequest>, ListDevicePoolsRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public ListDevicePoolsRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<ListDevicePoolsRequest> marshall(ListDevicePoolsRequest listDevicePoolsRequest) {
        if (listDevicePoolsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)listDevicePoolsRequest, "AWSDeviceFarm");
        request.addHeader("X-Amz-Target", "DeviceFarm_20150623.ListDevicePools");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (listDevicePoolsRequest.getArn() != null) {
                jsonGenerator.writeFieldName("arn").writeValue(listDevicePoolsRequest.getArn());
            }
            if (listDevicePoolsRequest.getType() != null) {
                jsonGenerator.writeFieldName("type").writeValue(listDevicePoolsRequest.getType());
            }
            if (listDevicePoolsRequest.getNextToken() != null) {
                jsonGenerator.writeFieldName("nextToken").writeValue(listDevicePoolsRequest.getNextToken());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

