/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.devicefarm.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.devicefarm.model.Rule;
import com.amazonaws.services.devicefarm.model.UpdateDevicePoolRequest;
import com.amazonaws.services.devicefarm.model.transform.RuleJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.json.SdkJsonProtocolFactory;
import com.amazonaws.util.json.StructuredJsonGenerator;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.List;

public class UpdateDevicePoolRequestMarshaller
implements Marshaller<Request<UpdateDevicePoolRequest>, UpdateDevicePoolRequest> {
    public Request<UpdateDevicePoolRequest> marshall(UpdateDevicePoolRequest updateDevicePoolRequest) {
        if (updateDevicePoolRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)updateDevicePoolRequest, "AWSDeviceFarm");
        request.addHeader("X-Amz-Target", "DeviceFarm_20150623.UpdateDevicePool");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            List<Rule> rulesList;
            StructuredJsonGenerator jsonGenerator = SdkJsonProtocolFactory.createWriter((boolean)false, (String)"1.1");
            jsonGenerator.writeStartObject();
            if (updateDevicePoolRequest.getArn() != null) {
                jsonGenerator.writeFieldName("arn").writeValue(updateDevicePoolRequest.getArn());
            }
            if (updateDevicePoolRequest.getName() != null) {
                jsonGenerator.writeFieldName("name").writeValue(updateDevicePoolRequest.getName());
            }
            if (updateDevicePoolRequest.getDescription() != null) {
                jsonGenerator.writeFieldName("description").writeValue(updateDevicePoolRequest.getDescription());
            }
            if ((rulesList = updateDevicePoolRequest.getRules()) != null) {
                jsonGenerator.writeFieldName("rules");
                jsonGenerator.writeStartArray();
                for (Rule rulesListValue : rulesList) {
                    if (rulesListValue == null) continue;
                    RuleJsonMarshaller.getInstance().marshall(rulesListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", jsonGenerator.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

