/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.devicefarm.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.devicefarm.model.Job;
import com.amazonaws.services.devicefarm.model.transform.CountersJsonMarshaller;
import com.amazonaws.services.devicefarm.model.transform.DeviceJsonMarshaller;
import com.amazonaws.services.devicefarm.model.transform.DeviceMinutesJsonMarshaller;
import com.amazonaws.util.json.StructuredJsonGenerator;

public class JobJsonMarshaller {
    private static JobJsonMarshaller instance;

    public void marshall(Job job, StructuredJsonGenerator jsonGenerator) {
        if (job == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            if (job.getArn() != null) {
                jsonGenerator.writeFieldName("arn").writeValue(job.getArn());
            }
            if (job.getName() != null) {
                jsonGenerator.writeFieldName("name").writeValue(job.getName());
            }
            if (job.getType() != null) {
                jsonGenerator.writeFieldName("type").writeValue(job.getType());
            }
            if (job.getCreated() != null) {
                jsonGenerator.writeFieldName("created").writeValue(job.getCreated());
            }
            if (job.getStatus() != null) {
                jsonGenerator.writeFieldName("status").writeValue(job.getStatus());
            }
            if (job.getResult() != null) {
                jsonGenerator.writeFieldName("result").writeValue(job.getResult());
            }
            if (job.getStarted() != null) {
                jsonGenerator.writeFieldName("started").writeValue(job.getStarted());
            }
            if (job.getStopped() != null) {
                jsonGenerator.writeFieldName("stopped").writeValue(job.getStopped());
            }
            if (job.getCounters() != null) {
                jsonGenerator.writeFieldName("counters");
                CountersJsonMarshaller.getInstance().marshall(job.getCounters(), jsonGenerator);
            }
            if (job.getMessage() != null) {
                jsonGenerator.writeFieldName("message").writeValue(job.getMessage());
            }
            if (job.getDevice() != null) {
                jsonGenerator.writeFieldName("device");
                DeviceJsonMarshaller.getInstance().marshall(job.getDevice(), jsonGenerator);
            }
            if (job.getDeviceMinutes() != null) {
                jsonGenerator.writeFieldName("deviceMinutes");
                DeviceMinutesJsonMarshaller.getInstance().marshall(job.getDeviceMinutes(), jsonGenerator);
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static JobJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new JobJsonMarshaller();
        }
        return instance;
    }
}

