/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.devicefarm.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.devicefarm.model.CPU;
import com.amazonaws.util.json.SdkJsonGenerator;

public class CPUJsonMarshaller {
    private static CPUJsonMarshaller instance;

    public void marshall(CPU cPU, SdkJsonGenerator jsonGenerator) {
        if (cPU == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            if (cPU.getFrequency() != null) {
                jsonGenerator.writeFieldName("frequency").writeValue(cPU.getFrequency());
            }
            if (cPU.getArchitecture() != null) {
                jsonGenerator.writeFieldName("architecture").writeValue(cPU.getArchitecture());
            }
            if (cPU.getClock() != null) {
                jsonGenerator.writeFieldName("clock").writeValue(cPU.getClock().doubleValue());
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static CPUJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new CPUJsonMarshaller();
        }
        return instance;
    }
}

