/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.devicefarm.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.devicefarm.model.DevicePoolCompatibilityResult;
import com.amazonaws.services.devicefarm.model.IncompatibilityMessage;
import com.amazonaws.services.devicefarm.model.transform.DeviceJsonMarshaller;
import com.amazonaws.services.devicefarm.model.transform.IncompatibilityMessageJsonMarshaller;
import com.amazonaws.util.json.JSONWriter;
import java.util.List;

public class DevicePoolCompatibilityResultJsonMarshaller {
    private static DevicePoolCompatibilityResultJsonMarshaller instance;

    public void marshall(DevicePoolCompatibilityResult devicePoolCompatibilityResult, JSONWriter jsonWriter) {
        if (devicePoolCompatibilityResult == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            List<IncompatibilityMessage> incompatibilityMessagesList;
            jsonWriter.object();
            if (devicePoolCompatibilityResult.getDevice() != null) {
                jsonWriter.key("device");
                DeviceJsonMarshaller.getInstance().marshall(devicePoolCompatibilityResult.getDevice(), jsonWriter);
            }
            if (devicePoolCompatibilityResult.getCompatible() != null) {
                jsonWriter.key("compatible").value((Object)devicePoolCompatibilityResult.getCompatible());
            }
            if ((incompatibilityMessagesList = devicePoolCompatibilityResult.getIncompatibilityMessages()) != null) {
                jsonWriter.key("incompatibilityMessages");
                jsonWriter.array();
                for (IncompatibilityMessage incompatibilityMessagesListValue : incompatibilityMessagesList) {
                    if (incompatibilityMessagesListValue == null) continue;
                    IncompatibilityMessageJsonMarshaller.getInstance().marshall(incompatibilityMessagesListValue, jsonWriter);
                }
                jsonWriter.endArray();
            }
            jsonWriter.endObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static DevicePoolCompatibilityResultJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new DevicePoolCompatibilityResultJsonMarshaller();
        }
        return instance;
    }
}

