/*
 * Copyright 2019-2024 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.deadline.model;

import java.io.Serializable;
import javax.annotation.Generated;

import com.amazonaws.AmazonWebServiceRequest;

/**
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/GetMonitor" target="_top">AWS API
 *      Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class GetMonitorRequest extends com.amazonaws.AmazonWebServiceRequest implements Serializable, Cloneable {

    /**
     * <p>
     * The unique identifier for the monitor. This ID is returned by the <code>CreateMonitor</code> operation.
     * </p>
     */
    private String monitorId;

    /**
     * <p>
     * The unique identifier for the monitor. This ID is returned by the <code>CreateMonitor</code> operation.
     * </p>
     * 
     * @param monitorId
     *        The unique identifier for the monitor. This ID is returned by the <code>CreateMonitor</code> operation.
     */

    public void setMonitorId(String monitorId) {
        this.monitorId = monitorId;
    }

    /**
     * <p>
     * The unique identifier for the monitor. This ID is returned by the <code>CreateMonitor</code> operation.
     * </p>
     * 
     * @return The unique identifier for the monitor. This ID is returned by the <code>CreateMonitor</code> operation.
     */

    public String getMonitorId() {
        return this.monitorId;
    }

    /**
     * <p>
     * The unique identifier for the monitor. This ID is returned by the <code>CreateMonitor</code> operation.
     * </p>
     * 
     * @param monitorId
     *        The unique identifier for the monitor. This ID is returned by the <code>CreateMonitor</code> operation.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public GetMonitorRequest withMonitorId(String monitorId) {
        setMonitorId(monitorId);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getMonitorId() != null)
            sb.append("MonitorId: ").append(getMonitorId());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof GetMonitorRequest == false)
            return false;
        GetMonitorRequest other = (GetMonitorRequest) obj;
        if (other.getMonitorId() == null ^ this.getMonitorId() == null)
            return false;
        if (other.getMonitorId() != null && other.getMonitorId().equals(this.getMonitorId()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getMonitorId() == null) ? 0 : getMonitorId().hashCode());
        return hashCode;
    }

    @Override
    public GetMonitorRequest clone() {
        return (GetMonitorRequest) super.clone();
    }

}
