/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.deadline.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.deadline.model.BudgetActionToAdd;
import com.amazonaws.services.deadline.model.BudgetSchedule;
import com.amazonaws.services.deadline.model.UsageTrackingResource;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CreateBudgetRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private List<BudgetActionToAdd> actions;
    private Float approximateDollarLimit;
    private String clientToken;
    private String description;
    private String displayName;
    private String farmId;
    private BudgetSchedule schedule;
    private UsageTrackingResource usageTrackingResource;

    public List<BudgetActionToAdd> getActions() {
        return this.actions;
    }

    public void setActions(Collection<BudgetActionToAdd> actions) {
        if (actions == null) {
            this.actions = null;
            return;
        }
        this.actions = new ArrayList<BudgetActionToAdd>(actions);
    }

    public CreateBudgetRequest withActions(BudgetActionToAdd ... actions) {
        if (this.actions == null) {
            this.setActions(new ArrayList<BudgetActionToAdd>(actions.length));
        }
        for (BudgetActionToAdd ele : actions) {
            this.actions.add(ele);
        }
        return this;
    }

    public CreateBudgetRequest withActions(Collection<BudgetActionToAdd> actions) {
        this.setActions(actions);
        return this;
    }

    public void setApproximateDollarLimit(Float approximateDollarLimit) {
        this.approximateDollarLimit = approximateDollarLimit;
    }

    public Float getApproximateDollarLimit() {
        return this.approximateDollarLimit;
    }

    public CreateBudgetRequest withApproximateDollarLimit(Float approximateDollarLimit) {
        this.setApproximateDollarLimit(approximateDollarLimit);
        return this;
    }

    public void setClientToken(String clientToken) {
        this.clientToken = clientToken;
    }

    public String getClientToken() {
        return this.clientToken;
    }

    public CreateBudgetRequest withClientToken(String clientToken) {
        this.setClientToken(clientToken);
        return this;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public CreateBudgetRequest withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public CreateBudgetRequest withDisplayName(String displayName) {
        this.setDisplayName(displayName);
        return this;
    }

    public void setFarmId(String farmId) {
        this.farmId = farmId;
    }

    public String getFarmId() {
        return this.farmId;
    }

    public CreateBudgetRequest withFarmId(String farmId) {
        this.setFarmId(farmId);
        return this;
    }

    public void setSchedule(BudgetSchedule schedule) {
        this.schedule = schedule;
    }

    public BudgetSchedule getSchedule() {
        return this.schedule;
    }

    public CreateBudgetRequest withSchedule(BudgetSchedule schedule) {
        this.setSchedule(schedule);
        return this;
    }

    public void setUsageTrackingResource(UsageTrackingResource usageTrackingResource) {
        this.usageTrackingResource = usageTrackingResource;
    }

    public UsageTrackingResource getUsageTrackingResource() {
        return this.usageTrackingResource;
    }

    public CreateBudgetRequest withUsageTrackingResource(UsageTrackingResource usageTrackingResource) {
        this.setUsageTrackingResource(usageTrackingResource);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getActions() != null) {
            sb.append("Actions: ").append(this.getActions()).append(",");
        }
        if (this.getApproximateDollarLimit() != null) {
            sb.append("ApproximateDollarLimit: ").append(this.getApproximateDollarLimit()).append(",");
        }
        if (this.getClientToken() != null) {
            sb.append("ClientToken: ").append(this.getClientToken()).append(",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: ").append("***Sensitive Data Redacted***").append(",");
        }
        if (this.getDisplayName() != null) {
            sb.append("DisplayName: ").append(this.getDisplayName()).append(",");
        }
        if (this.getFarmId() != null) {
            sb.append("FarmId: ").append(this.getFarmId()).append(",");
        }
        if (this.getSchedule() != null) {
            sb.append("Schedule: ").append(this.getSchedule()).append(",");
        }
        if (this.getUsageTrackingResource() != null) {
            sb.append("UsageTrackingResource: ").append(this.getUsageTrackingResource());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateBudgetRequest)) {
            return false;
        }
        CreateBudgetRequest other = (CreateBudgetRequest)obj;
        if (other.getActions() == null ^ this.getActions() == null) {
            return false;
        }
        if (other.getActions() != null && !other.getActions().equals(this.getActions())) {
            return false;
        }
        if (other.getApproximateDollarLimit() == null ^ this.getApproximateDollarLimit() == null) {
            return false;
        }
        if (other.getApproximateDollarLimit() != null && !other.getApproximateDollarLimit().equals(this.getApproximateDollarLimit())) {
            return false;
        }
        if (other.getClientToken() == null ^ this.getClientToken() == null) {
            return false;
        }
        if (other.getClientToken() != null && !other.getClientToken().equals(this.getClientToken())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getDisplayName() == null ^ this.getDisplayName() == null) {
            return false;
        }
        if (other.getDisplayName() != null && !other.getDisplayName().equals(this.getDisplayName())) {
            return false;
        }
        if (other.getFarmId() == null ^ this.getFarmId() == null) {
            return false;
        }
        if (other.getFarmId() != null && !other.getFarmId().equals(this.getFarmId())) {
            return false;
        }
        if (other.getSchedule() == null ^ this.getSchedule() == null) {
            return false;
        }
        if (other.getSchedule() != null && !other.getSchedule().equals(this.getSchedule())) {
            return false;
        }
        if (other.getUsageTrackingResource() == null ^ this.getUsageTrackingResource() == null) {
            return false;
        }
        return other.getUsageTrackingResource() == null || other.getUsageTrackingResource().equals(this.getUsageTrackingResource());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getActions() == null ? 0 : this.getActions().hashCode());
        hashCode = 31 * hashCode + (this.getApproximateDollarLimit() == null ? 0 : this.getApproximateDollarLimit().hashCode());
        hashCode = 31 * hashCode + (this.getClientToken() == null ? 0 : this.getClientToken().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getDisplayName() == null ? 0 : this.getDisplayName().hashCode());
        hashCode = 31 * hashCode + (this.getFarmId() == null ? 0 : this.getFarmId().hashCode());
        hashCode = 31 * hashCode + (this.getSchedule() == null ? 0 : this.getSchedule().hashCode());
        hashCode = 31 * hashCode + (this.getUsageTrackingResource() == null ? 0 : this.getUsageTrackingResource().hashCode());
        return hashCode;
    }

    public CreateBudgetRequest clone() {
        return (CreateBudgetRequest)super.clone();
    }
}

