/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.datazone.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.datazone.model.DataProductItem;

@SdkInternalApi
public class DataProductItemMarshaller {
    private static final MarshallingInfo<String> DOMAINID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("domainId").build();
    private static final MarshallingInfo<String> ITEMID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("itemId").build();
    private static final DataProductItemMarshaller instance = new DataProductItemMarshaller();

    public static DataProductItemMarshaller getInstance() {
        return instance;
    }

    public void marshall(DataProductItem dataProductItem, ProtocolMarshaller protocolMarshaller) {
        if (dataProductItem == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)dataProductItem.getDomainId(), DOMAINID_BINDING);
            protocolMarshaller.marshall((Object)dataProductItem.getItemId(), ITEMID_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

