/*
 * Copyright 2018-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.datazone.model;

import java.io.Serializable;
import javax.annotation.Generated;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.protocol.ProtocolMarshaller;

/**
 * <p>
 * The details of a provisioned resource of this Amazon DataZone environment.
 * </p>
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/Resource" target="_top">AWS API
 *      Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class Resource implements Serializable, Cloneable, StructuredPojo {

    /**
     * <p>
     * The name of a provisioned resource of this Amazon DataZone environment.
     * </p>
     */
    private String name;
    /**
     * <p>
     * The provider of a provisioned resource of this Amazon DataZone environment.
     * </p>
     */
    private String provider;
    /**
     * <p>
     * The type of a provisioned resource of this Amazon DataZone environment.
     * </p>
     */
    private String type;
    /**
     * <p>
     * The value of a provisioned resource of this Amazon DataZone environment.
     * </p>
     */
    private String value;

    /**
     * <p>
     * The name of a provisioned resource of this Amazon DataZone environment.
     * </p>
     * 
     * @param name
     *        The name of a provisioned resource of this Amazon DataZone environment.
     */

    public void setName(String name) {
        this.name = name;
    }

    /**
     * <p>
     * The name of a provisioned resource of this Amazon DataZone environment.
     * </p>
     * 
     * @return The name of a provisioned resource of this Amazon DataZone environment.
     */

    public String getName() {
        return this.name;
    }

    /**
     * <p>
     * The name of a provisioned resource of this Amazon DataZone environment.
     * </p>
     * 
     * @param name
     *        The name of a provisioned resource of this Amazon DataZone environment.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public Resource withName(String name) {
        setName(name);
        return this;
    }

    /**
     * <p>
     * The provider of a provisioned resource of this Amazon DataZone environment.
     * </p>
     * 
     * @param provider
     *        The provider of a provisioned resource of this Amazon DataZone environment.
     */

    public void setProvider(String provider) {
        this.provider = provider;
    }

    /**
     * <p>
     * The provider of a provisioned resource of this Amazon DataZone environment.
     * </p>
     * 
     * @return The provider of a provisioned resource of this Amazon DataZone environment.
     */

    public String getProvider() {
        return this.provider;
    }

    /**
     * <p>
     * The provider of a provisioned resource of this Amazon DataZone environment.
     * </p>
     * 
     * @param provider
     *        The provider of a provisioned resource of this Amazon DataZone environment.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public Resource withProvider(String provider) {
        setProvider(provider);
        return this;
    }

    /**
     * <p>
     * The type of a provisioned resource of this Amazon DataZone environment.
     * </p>
     * 
     * @param type
     *        The type of a provisioned resource of this Amazon DataZone environment.
     */

    public void setType(String type) {
        this.type = type;
    }

    /**
     * <p>
     * The type of a provisioned resource of this Amazon DataZone environment.
     * </p>
     * 
     * @return The type of a provisioned resource of this Amazon DataZone environment.
     */

    public String getType() {
        return this.type;
    }

    /**
     * <p>
     * The type of a provisioned resource of this Amazon DataZone environment.
     * </p>
     * 
     * @param type
     *        The type of a provisioned resource of this Amazon DataZone environment.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public Resource withType(String type) {
        setType(type);
        return this;
    }

    /**
     * <p>
     * The value of a provisioned resource of this Amazon DataZone environment.
     * </p>
     * 
     * @param value
     *        The value of a provisioned resource of this Amazon DataZone environment.
     */

    public void setValue(String value) {
        this.value = value;
    }

    /**
     * <p>
     * The value of a provisioned resource of this Amazon DataZone environment.
     * </p>
     * 
     * @return The value of a provisioned resource of this Amazon DataZone environment.
     */

    public String getValue() {
        return this.value;
    }

    /**
     * <p>
     * The value of a provisioned resource of this Amazon DataZone environment.
     * </p>
     * 
     * @param value
     *        The value of a provisioned resource of this Amazon DataZone environment.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public Resource withValue(String value) {
        setValue(value);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getName() != null)
            sb.append("Name: ").append(getName()).append(",");
        if (getProvider() != null)
            sb.append("Provider: ").append(getProvider()).append(",");
        if (getType() != null)
            sb.append("Type: ").append(getType()).append(",");
        if (getValue() != null)
            sb.append("Value: ").append(getValue());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof Resource == false)
            return false;
        Resource other = (Resource) obj;
        if (other.getName() == null ^ this.getName() == null)
            return false;
        if (other.getName() != null && other.getName().equals(this.getName()) == false)
            return false;
        if (other.getProvider() == null ^ this.getProvider() == null)
            return false;
        if (other.getProvider() != null && other.getProvider().equals(this.getProvider()) == false)
            return false;
        if (other.getType() == null ^ this.getType() == null)
            return false;
        if (other.getType() != null && other.getType().equals(this.getType()) == false)
            return false;
        if (other.getValue() == null ^ this.getValue() == null)
            return false;
        if (other.getValue() != null && other.getValue().equals(this.getValue()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getName() == null) ? 0 : getName().hashCode());
        hashCode = prime * hashCode + ((getProvider() == null) ? 0 : getProvider().hashCode());
        hashCode = prime * hashCode + ((getType() == null) ? 0 : getType().hashCode());
        hashCode = prime * hashCode + ((getValue() == null) ? 0 : getValue().hashCode());
        return hashCode;
    }

    @Override
    public Resource clone() {
        try {
            return (Resource) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

    @com.amazonaws.annotation.SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        com.amazonaws.services.datazone.model.transform.ResourceMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}
