/*
 * Copyright 2018-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.datazone;

import javax.annotation.Generated;

import com.amazonaws.services.datazone.model.*;
import com.amazonaws.*;

/**
 * Abstract implementation of {@code AmazonDataZone}. Convenient method forms pass through to the corresponding overload
 * that takes a request object, which throws an {@code UnsupportedOperationException}.
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class AbstractAmazonDataZone implements AmazonDataZone {

    protected AbstractAmazonDataZone() {
    }

    @Override
    public AcceptPredictionsResult acceptPredictions(AcceptPredictionsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public AcceptSubscriptionRequestResult acceptSubscriptionRequest(AcceptSubscriptionRequestRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CancelSubscriptionResult cancelSubscription(CancelSubscriptionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateAssetResult createAsset(CreateAssetRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateAssetRevisionResult createAssetRevision(CreateAssetRevisionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateAssetTypeResult createAssetType(CreateAssetTypeRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateDataSourceResult createDataSource(CreateDataSourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateDomainResult createDomain(CreateDomainRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateEnvironmentResult createEnvironment(CreateEnvironmentRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateEnvironmentProfileResult createEnvironmentProfile(CreateEnvironmentProfileRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateFormTypeResult createFormType(CreateFormTypeRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateGlossaryResult createGlossary(CreateGlossaryRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateGlossaryTermResult createGlossaryTerm(CreateGlossaryTermRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateGroupProfileResult createGroupProfile(CreateGroupProfileRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateListingChangeSetResult createListingChangeSet(CreateListingChangeSetRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateProjectResult createProject(CreateProjectRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateProjectMembershipResult createProjectMembership(CreateProjectMembershipRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateSubscriptionGrantResult createSubscriptionGrant(CreateSubscriptionGrantRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateSubscriptionRequestResult createSubscriptionRequest(CreateSubscriptionRequestRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateSubscriptionTargetResult createSubscriptionTarget(CreateSubscriptionTargetRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateUserProfileResult createUserProfile(CreateUserProfileRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteAssetResult deleteAsset(DeleteAssetRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteAssetTypeResult deleteAssetType(DeleteAssetTypeRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteDataSourceResult deleteDataSource(DeleteDataSourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteDomainResult deleteDomain(DeleteDomainRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteEnvironmentResult deleteEnvironment(DeleteEnvironmentRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteEnvironmentBlueprintConfigurationResult deleteEnvironmentBlueprintConfiguration(DeleteEnvironmentBlueprintConfigurationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteEnvironmentProfileResult deleteEnvironmentProfile(DeleteEnvironmentProfileRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteFormTypeResult deleteFormType(DeleteFormTypeRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteGlossaryResult deleteGlossary(DeleteGlossaryRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteGlossaryTermResult deleteGlossaryTerm(DeleteGlossaryTermRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteListingResult deleteListing(DeleteListingRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteProjectResult deleteProject(DeleteProjectRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteProjectMembershipResult deleteProjectMembership(DeleteProjectMembershipRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteSubscriptionGrantResult deleteSubscriptionGrant(DeleteSubscriptionGrantRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteSubscriptionRequestResult deleteSubscriptionRequest(DeleteSubscriptionRequestRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteSubscriptionTargetResult deleteSubscriptionTarget(DeleteSubscriptionTargetRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetAssetResult getAsset(GetAssetRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetAssetTypeResult getAssetType(GetAssetTypeRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetDataSourceResult getDataSource(GetDataSourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetDataSourceRunResult getDataSourceRun(GetDataSourceRunRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetDomainResult getDomain(GetDomainRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetEnvironmentResult getEnvironment(GetEnvironmentRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetEnvironmentBlueprintResult getEnvironmentBlueprint(GetEnvironmentBlueprintRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetEnvironmentBlueprintConfigurationResult getEnvironmentBlueprintConfiguration(GetEnvironmentBlueprintConfigurationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetEnvironmentProfileResult getEnvironmentProfile(GetEnvironmentProfileRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetFormTypeResult getFormType(GetFormTypeRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetGlossaryResult getGlossary(GetGlossaryRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetGlossaryTermResult getGlossaryTerm(GetGlossaryTermRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetGroupProfileResult getGroupProfile(GetGroupProfileRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetIamPortalLoginUrlResult getIamPortalLoginUrl(GetIamPortalLoginUrlRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetListingResult getListing(GetListingRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetProjectResult getProject(GetProjectRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetSubscriptionResult getSubscription(GetSubscriptionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetSubscriptionGrantResult getSubscriptionGrant(GetSubscriptionGrantRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetSubscriptionRequestDetailsResult getSubscriptionRequestDetails(GetSubscriptionRequestDetailsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetSubscriptionTargetResult getSubscriptionTarget(GetSubscriptionTargetRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetUserProfileResult getUserProfile(GetUserProfileRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListAssetRevisionsResult listAssetRevisions(ListAssetRevisionsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListDataSourceRunActivitiesResult listDataSourceRunActivities(ListDataSourceRunActivitiesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListDataSourceRunsResult listDataSourceRuns(ListDataSourceRunsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListDataSourcesResult listDataSources(ListDataSourcesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListDomainsResult listDomains(ListDomainsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListEnvironmentBlueprintConfigurationsResult listEnvironmentBlueprintConfigurations(ListEnvironmentBlueprintConfigurationsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListEnvironmentBlueprintsResult listEnvironmentBlueprints(ListEnvironmentBlueprintsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListEnvironmentProfilesResult listEnvironmentProfiles(ListEnvironmentProfilesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListEnvironmentsResult listEnvironments(ListEnvironmentsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListNotificationsResult listNotifications(ListNotificationsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListProjectMembershipsResult listProjectMemberships(ListProjectMembershipsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListProjectsResult listProjects(ListProjectsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListSubscriptionGrantsResult listSubscriptionGrants(ListSubscriptionGrantsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListSubscriptionRequestsResult listSubscriptionRequests(ListSubscriptionRequestsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListSubscriptionTargetsResult listSubscriptionTargets(ListSubscriptionTargetsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListSubscriptionsResult listSubscriptions(ListSubscriptionsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListTagsForResourceResult listTagsForResource(ListTagsForResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public PutEnvironmentBlueprintConfigurationResult putEnvironmentBlueprintConfiguration(PutEnvironmentBlueprintConfigurationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public RejectPredictionsResult rejectPredictions(RejectPredictionsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public RejectSubscriptionRequestResult rejectSubscriptionRequest(RejectSubscriptionRequestRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public RevokeSubscriptionResult revokeSubscription(RevokeSubscriptionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public SearchResult search(SearchRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public SearchGroupProfilesResult searchGroupProfiles(SearchGroupProfilesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public SearchListingsResult searchListings(SearchListingsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public SearchTypesResult searchTypes(SearchTypesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public SearchUserProfilesResult searchUserProfiles(SearchUserProfilesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public StartDataSourceRunResult startDataSourceRun(StartDataSourceRunRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public TagResourceResult tagResource(TagResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UntagResourceResult untagResource(UntagResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateDataSourceResult updateDataSource(UpdateDataSourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateDomainResult updateDomain(UpdateDomainRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateEnvironmentResult updateEnvironment(UpdateEnvironmentRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateEnvironmentProfileResult updateEnvironmentProfile(UpdateEnvironmentProfileRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateGlossaryResult updateGlossary(UpdateGlossaryRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateGlossaryTermResult updateGlossaryTerm(UpdateGlossaryTermRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateGroupProfileResult updateGroupProfile(UpdateGroupProfileRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateProjectResult updateProject(UpdateProjectRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateSubscriptionGrantStatusResult updateSubscriptionGrantStatus(UpdateSubscriptionGrantStatusRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateSubscriptionRequestResult updateSubscriptionRequest(UpdateSubscriptionRequestRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateSubscriptionTargetResult updateSubscriptionTarget(UpdateSubscriptionTargetRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateUserProfileResult updateUserProfile(UpdateUserProfileRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public void shutdown() {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public com.amazonaws.ResponseMetadata getCachedResponseMetadata(com.amazonaws.AmazonWebServiceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

}
