/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.datasync.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.datasync.model.DiscoveryResourceType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DescribeStorageSystemResourcesRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String discoveryJobArn;
    private String resourceType;
    private List<String> resourceIds;
    private Map<String, List<String>> filter;
    private Integer maxResults;
    private String nextToken;

    public void setDiscoveryJobArn(String discoveryJobArn) {
        this.discoveryJobArn = discoveryJobArn;
    }

    public String getDiscoveryJobArn() {
        return this.discoveryJobArn;
    }

    public DescribeStorageSystemResourcesRequest withDiscoveryJobArn(String discoveryJobArn) {
        this.setDiscoveryJobArn(discoveryJobArn);
        return this;
    }

    public void setResourceType(String resourceType) {
        this.resourceType = resourceType;
    }

    public String getResourceType() {
        return this.resourceType;
    }

    public DescribeStorageSystemResourcesRequest withResourceType(String resourceType) {
        this.setResourceType(resourceType);
        return this;
    }

    public DescribeStorageSystemResourcesRequest withResourceType(DiscoveryResourceType resourceType) {
        this.resourceType = resourceType.toString();
        return this;
    }

    public List<String> getResourceIds() {
        return this.resourceIds;
    }

    public void setResourceIds(Collection<String> resourceIds) {
        if (resourceIds == null) {
            this.resourceIds = null;
            return;
        }
        this.resourceIds = new ArrayList<String>(resourceIds);
    }

    public DescribeStorageSystemResourcesRequest withResourceIds(String ... resourceIds) {
        if (this.resourceIds == null) {
            this.setResourceIds(new ArrayList<String>(resourceIds.length));
        }
        for (String ele : resourceIds) {
            this.resourceIds.add(ele);
        }
        return this;
    }

    public DescribeStorageSystemResourcesRequest withResourceIds(Collection<String> resourceIds) {
        this.setResourceIds(resourceIds);
        return this;
    }

    public Map<String, List<String>> getFilter() {
        return this.filter;
    }

    public void setFilter(Map<String, List<String>> filter) {
        this.filter = filter;
    }

    public DescribeStorageSystemResourcesRequest withFilter(Map<String, List<String>> filter) {
        this.setFilter(filter);
        return this;
    }

    public DescribeStorageSystemResourcesRequest addFilterEntry(String key, List<String> value) {
        if (null == this.filter) {
            this.filter = new HashMap<String, List<String>>();
        }
        if (this.filter.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.filter.put(key, value);
        return this;
    }

    public DescribeStorageSystemResourcesRequest clearFilterEntries() {
        this.filter = null;
        return this;
    }

    public void setMaxResults(Integer maxResults) {
        this.maxResults = maxResults;
    }

    public Integer getMaxResults() {
        return this.maxResults;
    }

    public DescribeStorageSystemResourcesRequest withMaxResults(Integer maxResults) {
        this.setMaxResults(maxResults);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public DescribeStorageSystemResourcesRequest withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDiscoveryJobArn() != null) {
            sb.append("DiscoveryJobArn: ").append(this.getDiscoveryJobArn()).append(",");
        }
        if (this.getResourceType() != null) {
            sb.append("ResourceType: ").append(this.getResourceType()).append(",");
        }
        if (this.getResourceIds() != null) {
            sb.append("ResourceIds: ").append(this.getResourceIds()).append(",");
        }
        if (this.getFilter() != null) {
            sb.append("Filter: ").append(this.getFilter()).append(",");
        }
        if (this.getMaxResults() != null) {
            sb.append("MaxResults: ").append(this.getMaxResults()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeStorageSystemResourcesRequest)) {
            return false;
        }
        DescribeStorageSystemResourcesRequest other = (DescribeStorageSystemResourcesRequest)obj;
        if (other.getDiscoveryJobArn() == null ^ this.getDiscoveryJobArn() == null) {
            return false;
        }
        if (other.getDiscoveryJobArn() != null && !other.getDiscoveryJobArn().equals(this.getDiscoveryJobArn())) {
            return false;
        }
        if (other.getResourceType() == null ^ this.getResourceType() == null) {
            return false;
        }
        if (other.getResourceType() != null && !other.getResourceType().equals(this.getResourceType())) {
            return false;
        }
        if (other.getResourceIds() == null ^ this.getResourceIds() == null) {
            return false;
        }
        if (other.getResourceIds() != null && !other.getResourceIds().equals(this.getResourceIds())) {
            return false;
        }
        if (other.getFilter() == null ^ this.getFilter() == null) {
            return false;
        }
        if (other.getFilter() != null && !other.getFilter().equals(this.getFilter())) {
            return false;
        }
        if (other.getMaxResults() == null ^ this.getMaxResults() == null) {
            return false;
        }
        if (other.getMaxResults() != null && !other.getMaxResults().equals(this.getMaxResults())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return other.getNextToken() == null || other.getNextToken().equals(this.getNextToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDiscoveryJobArn() == null ? 0 : this.getDiscoveryJobArn().hashCode());
        hashCode = 31 * hashCode + (this.getResourceType() == null ? 0 : this.getResourceType().hashCode());
        hashCode = 31 * hashCode + (this.getResourceIds() == null ? 0 : this.getResourceIds().hashCode());
        hashCode = 31 * hashCode + (this.getFilter() == null ? 0 : this.getFilter().hashCode());
        hashCode = 31 * hashCode + (this.getMaxResults() == null ? 0 : this.getMaxResults().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return hashCode;
    }

    public DescribeStorageSystemResourcesRequest clone() {
        return (DescribeStorageSystemResourcesRequest)super.clone();
    }
}

