/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.customerprofiles.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.customerprofiles.model.WorkflowStepItem;
import com.amazonaws.services.customerprofiles.model.WorkflowType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class GetWorkflowStepsResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private String workflowId;
    private String workflowType;
    private List<WorkflowStepItem> items;
    private String nextToken;

    public void setWorkflowId(String workflowId) {
        this.workflowId = workflowId;
    }

    public String getWorkflowId() {
        return this.workflowId;
    }

    public GetWorkflowStepsResult withWorkflowId(String workflowId) {
        this.setWorkflowId(workflowId);
        return this;
    }

    public void setWorkflowType(String workflowType) {
        this.workflowType = workflowType;
    }

    public String getWorkflowType() {
        return this.workflowType;
    }

    public GetWorkflowStepsResult withWorkflowType(String workflowType) {
        this.setWorkflowType(workflowType);
        return this;
    }

    public GetWorkflowStepsResult withWorkflowType(WorkflowType workflowType) {
        this.workflowType = workflowType.toString();
        return this;
    }

    public List<WorkflowStepItem> getItems() {
        return this.items;
    }

    public void setItems(Collection<WorkflowStepItem> items) {
        if (items == null) {
            this.items = null;
            return;
        }
        this.items = new ArrayList<WorkflowStepItem>(items);
    }

    public GetWorkflowStepsResult withItems(WorkflowStepItem ... items) {
        if (this.items == null) {
            this.setItems(new ArrayList<WorkflowStepItem>(items.length));
        }
        for (WorkflowStepItem ele : items) {
            this.items.add(ele);
        }
        return this;
    }

    public GetWorkflowStepsResult withItems(Collection<WorkflowStepItem> items) {
        this.setItems(items);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public GetWorkflowStepsResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getWorkflowId() != null) {
            sb.append("WorkflowId: ").append(this.getWorkflowId()).append(",");
        }
        if (this.getWorkflowType() != null) {
            sb.append("WorkflowType: ").append(this.getWorkflowType()).append(",");
        }
        if (this.getItems() != null) {
            sb.append("Items: ").append(this.getItems()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetWorkflowStepsResult)) {
            return false;
        }
        GetWorkflowStepsResult other = (GetWorkflowStepsResult)obj;
        if (other.getWorkflowId() == null ^ this.getWorkflowId() == null) {
            return false;
        }
        if (other.getWorkflowId() != null && !other.getWorkflowId().equals(this.getWorkflowId())) {
            return false;
        }
        if (other.getWorkflowType() == null ^ this.getWorkflowType() == null) {
            return false;
        }
        if (other.getWorkflowType() != null && !other.getWorkflowType().equals(this.getWorkflowType())) {
            return false;
        }
        if (other.getItems() == null ^ this.getItems() == null) {
            return false;
        }
        if (other.getItems() != null && !other.getItems().equals(this.getItems())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return other.getNextToken() == null || other.getNextToken().equals(this.getNextToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getWorkflowId() == null ? 0 : this.getWorkflowId().hashCode());
        hashCode = 31 * hashCode + (this.getWorkflowType() == null ? 0 : this.getWorkflowType().hashCode());
        hashCode = 31 * hashCode + (this.getItems() == null ? 0 : this.getItems().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return hashCode;
    }

    public GetWorkflowStepsResult clone() {
        try {
            return (GetWorkflowStepsResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

